/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.okhttp3.internal.publicsuffix;

import java.net.IDN;
import java.util.List;
import org.apache.ozone.shaded.kotlin.Metadata;
import org.apache.ozone.shaded.kotlin.collections.CollectionsKt;
import org.apache.ozone.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import org.apache.ozone.shaded.kotlin.jvm.internal.Intrinsics;
import org.apache.ozone.shaded.kotlin.sequences.SequencesKt;
import org.apache.ozone.shaded.kotlin.text.Charsets;
import org.apache.ozone.shaded.kotlin.text.StringsKt;
import org.apache.ozone.shaded.okhttp3.internal._UtilCommonKt;
import org.apache.ozone.shaded.okhttp3.internal.publicsuffix.PublicSuffixList;
import org.apache.ozone.shaded.okhttp3.internal.publicsuffix.PublicSuffixList_jvmKt;
import org.apache.ozone.shaded.okio.ByteString;
import org.apache.ozone.shaded.org.jetbrains.annotations.NotNull;
import org.apache.ozone.shaded.org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/apache/ozone/shaded/okhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "publicSuffixList", "Lorg/apache/ozone/shaded/okhttp3/internal/publicsuffix/PublicSuffixList;", "<init>", "(Lokhttp3/internal/publicsuffix/PublicSuffixList;)V", "getEffectiveTldPlusOne", "", "domain", "splitDomain", "", "findMatchingRule", "domainLabels", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicSuffixList publicSuffixList;
    @NotNull
    private static final ByteString WILDCARD_LABEL;
    @NotNull
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    @NotNull
    private static final PublicSuffixDatabase instance;

    public PublicSuffixDatabase(@NotNull PublicSuffixList publicSuffixList) {
        Intrinsics.checkNotNullParameter(publicSuffixList, "publicSuffixList");
        this.publicSuffixList = publicSuffixList;
    }

    @Nullable
    public final String getEffectiveTldPlusOne(@NotNull String domain) {
        Intrinsics.checkNotNullParameter(domain, "domain");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNull(unicodeDomain);
        List<String> domainLabels = this.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (rule.size() + 1);
        return SequencesKt.joinToString$default(SequencesKt.drop(CollectionsKt.asSequence((Iterable)this.splitDomain(domain)), firstLabelOffset), ".", null, null, 0, null, null, 62, null);
    }

    private final List<String> splitDomain(String domain) {
        char[] cArray = new char[]{'.'};
        List domainLabels = StringsKt.split$default((CharSequence)domain, cArray, false, 0, 6, null);
        if (Intrinsics.areEqual(CollectionsKt.last(domainLabels), "")) {
            return CollectionsKt.dropLast(domainLabels, 1);
        }
        return domainLabels;
    }

    private final List<String> findMatchingRule(List<String> domainLabels) {
        char[] cArray;
        List list;
        List exactRuleLabels;
        char[] cArray2;
        String rule;
        int n;
        this.publicSuffixList.ensureLoaded();
        int n2 = 0;
        int n3 = domainLabels.size();
        ByteString[] byteStringArray = new ByteString[n3];
        while (n2 < n3) {
            int n4 = n2++;
            byteStringArray[n4] = ByteString.Companion.encodeUtf8(domainLabels.get(n4));
        }
        ByteString[] domainLabelsUtf8Bytes = byteStringArray;
        String exactMatch = null;
        int n5 = domainLabelsUtf8Bytes.length;
        for (int i = 0; i < n5; ++i) {
            String rule2 = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixList.getBytes(), domainLabelsUtf8Bytes, i);
            if (rule2 == null) continue;
            exactMatch = rule2;
            break;
        }
        Object wildcardMatch = null;
        if (domainLabelsUtf8Bytes.length > 1) {
            ByteString[] labelsWithWildcard = (ByteString[])domainLabelsUtf8Bytes.clone();
            n = labelsWithWildcard.length - 1;
            for (int labelIndex = 0; labelIndex < n; ++labelIndex) {
                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                rule = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixList.getBytes(), labelsWithWildcard, labelIndex);
                if (rule == null) continue;
                wildcardMatch = rule;
                break;
            }
        }
        String exception = null;
        if (wildcardMatch != null) {
            n = domainLabelsUtf8Bytes.length - 1;
            for (int labelIndex = 0; labelIndex < n; ++labelIndex) {
                rule = PublicSuffixDatabase.Companion.binarySearch(this.publicSuffixList.getExceptionBytes(), domainLabelsUtf8Bytes, labelIndex);
                if (rule == null) continue;
                exception = rule;
                break;
            }
        }
        if (exception != null) {
            exception = '!' + exception;
            char[] labelIndex = new char[]{'.'};
            return StringsKt.split$default((CharSequence)exception, labelIndex, false, 0, 6, null);
        }
        if (exactMatch == null && wildcardMatch == null) {
            return PREVAILING_RULE;
        }
        Object object = exactMatch;
        if (object == null || (object = StringsKt.split$default((CharSequence)object, cArray2 = new char[]{'.'}, false, 0, 6, null)) == null) {
            object = exactRuleLabels = CollectionsKt.emptyList();
        }
        if ((list = wildcardMatch) == null || (list = StringsKt.split$default((CharSequence)((Object)list), cArray = new char[]{'.'}, false, 0, 6, null)) == null) {
            list = CollectionsKt.emptyList();
        }
        List wildcardRuleLabels = list;
        return exactRuleLabels.size() > wildcardRuleLabels.size() ? exactRuleLabels : wildcardRuleLabels;
    }

    static {
        byte[] byArray = new byte[]{42};
        WILDCARD_LABEL = ByteString.Companion.of(byArray);
        PREVAILING_RULE = CollectionsKt.listOf("*");
        instance = new PublicSuffixDatabase(PublicSuffixList_jvmKt.getDefault(PublicSuffixList.Companion));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\fJ)\u0010\u000e\u001a\u0004\u0018\u00010\b*\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/apache/ozone/shaded/okhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "<init>", "()V", "WILDCARD_LABEL", "Lorg/apache/ozone/shaded/okio/ByteString;", "PREVAILING_RULE", "", "", "EXCEPTION_MARKER", "", "instance", "Lorg/apache/ozone/shaded/okhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "(Lokio/ByteString;[Lokio/ByteString;I)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PublicSuffixDatabase get() {
            return instance;
        }

        private final String binarySearch(ByteString $this$binarySearch, ByteString[] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.size();
            String match = null;
            while (low < high) {
                int mid;
                for (mid = (low + high) / 2; mid > -1 && $this$binarySearch.getByte(mid) != 10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch.getByte(mid + end) != 10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int compareResult = 0;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0 = 0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = _UtilCommonKt.and(labels[currentLabelIndex].getByte(currentLabelByteIndex), 255);
                    }
                    int byte1 = _UtilCommonKt.and($this$binarySearch.getByte(mid + publicSuffixByteIndex), 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].size() != currentLabelByteIndex) continue;
                    if (currentLabelIndex == labels.length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].size() - currentLabelByteIndex;
                int n = labels.length;
                for (int i = currentLabelIndex + 1; i < n; ++i) {
                    labelBytesLeft += labels[i].size();
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                match = $this$binarySearch.substring(mid, mid + publicSuffixLength).string(Charsets.UTF_8);
                break;
            }
            return match;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

