/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty.client;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.protocol.ClientInvocationId;
import org.apache.ozone.shaded.org.apache.ratis.protocol.DataStreamPacket;
import org.apache.ozone.shaded.org.apache.ratis.protocol.DataStreamReply;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.util.concurrent.ScheduledFuture;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientReplies {
    public static final Logger LOG = LoggerFactory.getLogger(NettyClientReplies.class);
    private final ConcurrentMap<ClientInvocationId, ReplyMap> replies = new ConcurrentHashMap<ClientInvocationId, ReplyMap>();

    ReplyMap getReplyMap(ClientInvocationId clientInvocationId) {
        MemoizedSupplier<ReplyMap> q = MemoizedSupplier.valueOf(() -> new ReplyMap(clientInvocationId));
        return this.replies.computeIfAbsent(clientInvocationId, key -> (ReplyMap)q.get());
    }

    static class ReplyEntry {
        private final boolean isClosed;
        private final CompletableFuture<DataStreamReply> replyFuture;
        private ScheduledFuture<?> timeoutFuture;

        ReplyEntry(boolean isClosed, CompletableFuture<DataStreamReply> replyFuture) {
            this.isClosed = isClosed;
            this.replyFuture = replyFuture;
        }

        boolean isClosed() {
            return this.isClosed;
        }

        synchronized void complete(DataStreamReply reply) {
            ReplyEntry.cancel(this.timeoutFuture);
            this.replyFuture.complete(reply);
        }

        synchronized void completeExceptionally(Throwable t2) {
            ReplyEntry.cancel(this.timeoutFuture);
            this.replyFuture.completeExceptionally(t2);
        }

        static void cancel(ScheduledFuture<?> future) {
            if (future != null) {
                future.cancel(true);
            }
        }

        synchronized void scheduleTimeout(Supplier<ScheduledFuture<?>> scheduleMethod) {
            if (!this.replyFuture.isDone()) {
                this.timeoutFuture = scheduleMethod.get();
            }
        }
    }

    static class RequestEntry {
        private final long streamOffset;
        private final RaftProtos.DataStreamPacketHeaderProto.Type type;

        RequestEntry(DataStreamPacket packet) {
            this.streamOffset = packet.getStreamOffset();
            this.type = packet.getType();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestEntry that = (RequestEntry)o;
            return this.streamOffset == that.streamOffset && this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.streamOffset);
        }

        public String toString() {
            return "Request{streamOffset=" + this.streamOffset + ", type=" + this.type + '}';
        }
    }

    class ReplyMap {
        private final ClientInvocationId clientInvocationId;
        private final Map<RequestEntry, ReplyEntry> map = new ConcurrentHashMap<RequestEntry, ReplyEntry>();

        ReplyMap(ClientInvocationId clientInvocationId) {
            this.clientInvocationId = clientInvocationId;
        }

        ReplyEntry submitRequest(RequestEntry requestEntry, boolean isClose, CompletableFuture<DataStreamReply> f) {
            LOG.debug("put {} to the map for {}", (Object)requestEntry, (Object)this.clientInvocationId);
            return this.map.computeIfAbsent(requestEntry, r -> new ReplyEntry(isClose, f));
        }

        void receiveReply(DataStreamReply reply) {
            RequestEntry requestEntry = new RequestEntry(reply);
            ReplyEntry replyEntry = this.map.remove(requestEntry);
            LOG.debug("remove: {}; replyEntry: {}; reply: {}", new Object[]{requestEntry, replyEntry, reply});
            if (replyEntry == null) {
                LOG.debug("Request not found: {}", (Object)this);
                return;
            }
            replyEntry.complete(reply);
            if (!reply.isSuccess()) {
                this.failAll("a request failed with " + reply);
            } else if (replyEntry.isClosed()) {
                this.removeThisMap();
            }
        }

        private void removeThisMap() {
            ReplyMap removed = (ReplyMap)NettyClientReplies.this.replies.remove(this.clientInvocationId);
            Preconditions.assertSame(removed, this, "removed");
        }

        void completeExceptionally(Throwable e) {
            this.removeThisMap();
            for (ReplyEntry entry : this.map.values()) {
                entry.completeExceptionally(e);
            }
            this.map.clear();
        }

        private void failAll(String message) {
            this.completeExceptionally(new IllegalStateException(this + ": " + message));
        }

        void fail(RequestEntry requestEntry) {
            this.map.remove(requestEntry);
            this.failAll(requestEntry + " failed ");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (RequestEntry requestEntry : this.map.keySet()) {
                builder.append(requestEntry).append(", ");
            }
            return builder.toString();
        }
    }
}

