/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.ozone.recon.MetricsServiceProviderFactory;
import org.apache.hadoop.ozone.recon.spi.MetricsServiceProvider;
import org.apache.hadoop.ozone.recon.spi.impl.PrometheusServiceProviderImpl;

@Path(value="/metrics")
public class MetricsProxyEndpoint {
    private MetricsServiceProvider metricsServiceProvider;

    @Inject
    public MetricsProxyEndpoint(MetricsServiceProviderFactory metricsServiceProviderFactory) {
        this.metricsServiceProvider = metricsServiceProviderFactory.getMetricsServiceProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{api}")
    public void getMetricsResponse(@DefaultValue(value="query") @PathParam(value="api") String api, @Context UriInfo uriInfo, @Context HttpServletResponse httpServletResponse) throws Exception {
        block26: {
            if (this.metricsServiceProvider != null) {
                InputStream inputStream;
                HttpURLConnection connection = this.metricsServiceProvider.getMetricsResponse(api, uriInfo.getRequestUri().getQuery());
                if (Response.Status.fromStatusCode((int)connection.getResponseCode()).getFamily() == Response.Status.Family.SUCCESSFUL) {
                    inputStream = connection.getInputStream();
                } else {
                    httpServletResponse.setStatus(502);
                    inputStream = connection.getErrorStream();
                }
                try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();
                     ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
                     WritableByteChannel outputChannel = Channels.newChannel((OutputStream)outputStream);){
                    ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
                    while (inputChannel.read(buffer) != -1) {
                        buffer.flip();
                        outputChannel.write(buffer);
                        buffer.compact();
                    }
                    buffer.flip();
                    while (buffer.hasRemaining()) {
                        outputChannel.write(buffer);
                    }
                    break block26;
                }
                finally {
                    inputStream.close();
                }
            }
            httpServletResponse.sendError(502, "Metrics endpoint is not configured. Configure " + PrometheusServiceProviderImpl.getEndpointConfigKey() + " and try again later.");
        }
    }
}

