/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconFileMetadataManager;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountTaskHelper;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;

public class FileSizeCountTaskFSO
implements ReconOmTask {
    private final ReconFileMetadataManager reconFileMetadataManager;
    private final OzoneConfiguration ozoneConfiguration;

    @Inject
    public FileSizeCountTaskFSO(ReconFileMetadataManager reconFileMetadataManager, OzoneConfiguration configuration) throws IOException {
        this.reconFileMetadataManager = reconFileMetadataManager;
        this.ozoneConfiguration = configuration;
    }

    @Override
    public ReconOmTask getStagedTask(ReconOMMetadataManager stagedOmMetadataManager, DBStore stagedReconDbStore) throws IOException {
        return new FileSizeCountTaskFSO(this.reconFileMetadataManager.getStagedReconFileMetadataManager(stagedReconDbStore), this.ozoneConfiguration);
    }

    @Override
    public ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager) {
        return FileSizeCountTaskHelper.reprocess(omMetadataManager, this.reconFileMetadataManager, BucketLayout.FILE_SYSTEM_OPTIMIZED, this.getTaskName());
    }

    @Override
    public ReconOmTask.TaskResult process(OMUpdateEventBatch events, Map<String, Integer> subTaskSeekPosMap) {
        return FileSizeCountTaskHelper.processEvents(events, "fileTable", this.reconFileMetadataManager, this.getTaskName());
    }

    @Override
    public String getTaskName() {
        return "FileSizeCountTaskFSO";
    }
}

