/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithFSO;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithLegacy;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskWithOBS;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTask
implements ReconOmTask {
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTask.class);
    private static final AtomicReference<RebuildState> REBUILD_STATE = new AtomicReference<RebuildState>(RebuildState.IDLE);
    private final ReconNamespaceSummaryManager reconNamespaceSummaryManager;
    private final ReconOMMetadataManager reconOMMetadataManager;
    private final OzoneConfiguration ozoneConfiguration;
    private final NSSummaryTaskWithFSO nsSummaryTaskWithFSO;
    private final NSSummaryTaskWithLegacy nsSummaryTaskWithLegacy;
    private final NSSummaryTaskWithOBS nsSummaryTaskWithOBS;

    @Inject
    public NSSummaryTask(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, OzoneConfiguration ozoneConfiguration) {
        this.reconNamespaceSummaryManager = reconNamespaceSummaryManager;
        this.reconOMMetadataManager = reconOMMetadataManager;
        this.ozoneConfiguration = ozoneConfiguration;
        long nsSummaryFlushToDBMaxThreshold = ozoneConfiguration.getLong("ozone.recon.nssummary.flush.db.max.threshold", 150000L);
        this.nsSummaryTaskWithFSO = new NSSummaryTaskWithFSO(reconNamespaceSummaryManager, reconOMMetadataManager, nsSummaryFlushToDBMaxThreshold);
        this.nsSummaryTaskWithLegacy = new NSSummaryTaskWithLegacy(reconNamespaceSummaryManager, reconOMMetadataManager, ozoneConfiguration, nsSummaryFlushToDBMaxThreshold);
        this.nsSummaryTaskWithOBS = new NSSummaryTaskWithOBS(reconNamespaceSummaryManager, reconOMMetadataManager, nsSummaryFlushToDBMaxThreshold);
    }

    @Override
    public NSSummaryTask getStagedTask(ReconOMMetadataManager stagedOmMetadataManager, DBStore stagedReconDbStore) throws IOException {
        ReconNamespaceSummaryManager stagedNsSummaryManager = this.reconNamespaceSummaryManager.getStagedNsSummaryManager(stagedReconDbStore);
        return new NSSummaryTask(stagedNsSummaryManager, stagedOmMetadataManager, this.ozoneConfiguration);
    }

    @Override
    public String getTaskName() {
        return "NSSummaryTask";
    }

    public static RebuildState getRebuildState() {
        return REBUILD_STATE.get();
    }

    @Override
    public ReconOmTask.TaskResult process(OMUpdateEventBatch events, Map<String, Integer> subTaskSeekPosMap) {
        boolean anyFailure = false;
        HashMap<String, Integer> updatedSeekPositions = new HashMap<String, Integer>();
        Integer bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.FSO.name(), 0);
        Pair<Integer, Boolean> bucketResult = this.nsSummaryTaskWithFSO.processWithFSO(events, bucketSeek);
        updatedSeekPositions.put(BucketType.FSO.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithFSO failed.");
            anyFailure = true;
        }
        bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.LEGACY.name(), 0);
        bucketResult = this.nsSummaryTaskWithLegacy.processWithLegacy(events, bucketSeek);
        updatedSeekPositions.put(BucketType.LEGACY.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithLegacy failed.");
            anyFailure = true;
        }
        bucketSeek = subTaskSeekPosMap.getOrDefault(BucketType.OBS.name(), 0);
        bucketResult = this.nsSummaryTaskWithOBS.processWithOBS(events, bucketSeek);
        updatedSeekPositions.put(BucketType.OBS.name(), (Integer)bucketResult.getLeft());
        if (!((Boolean)bucketResult.getRight()).booleanValue()) {
            LOG.error("processWithOBS failed.");
            anyFailure = true;
        }
        return new ReconOmTask.TaskResult.Builder().setTaskName(this.getTaskName()).setSubTaskSeekPositions(updatedSeekPositions).setTaskSuccess(!anyFailure).build();
    }

    @Override
    public ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager) {
        RebuildState currentState = REBUILD_STATE.get();
        if (currentState == RebuildState.RUNNING) {
            LOG.info("NSSummary tree rebuild is already in progress, skipping duplicate request.");
            return this.buildTaskResult(false);
        }
        if (!REBUILD_STATE.compareAndSet(currentState, RebuildState.RUNNING)) {
            if (REBUILD_STATE.get() == RebuildState.RUNNING) {
                LOG.info("Rebuild already in progress by another thread, returning success");
                return this.buildTaskResult(true);
            }
            LOG.info("Failed to acquire rebuild lock, unknown state");
            return this.buildTaskResult(false);
        }
        LOG.info("Starting NSSummary tree reprocess with unified control...");
        long startTime = System.nanoTime();
        try {
            return this.executeReprocess(omMetadataManager, startTime);
        }
        catch (Exception e) {
            LOG.error("NSSummary reprocess failed with exception.", (Throwable)e);
            REBUILD_STATE.set(RebuildState.FAILED);
            return this.buildTaskResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReconOmTask.TaskResult executeReprocess(OMMetadataManager omMetadataManager, long startTime) {
        ReconOmTask.TaskResult taskResult;
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        try {
            this.reconNamespaceSummaryManager.clearNSSummaryTable();
        }
        catch (IOException ioEx) {
            LOG.error("Unable to clear NSSummary table in Recon DB. ", (Throwable)ioEx);
            REBUILD_STATE.set(RebuildState.FAILED);
            return this.buildTaskResult(false);
        }
        tasks.add(() -> this.nsSummaryTaskWithFSO.reprocessWithFSO(omMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithLegacy.reprocessWithLegacy(this.reconOMMetadataManager));
        tasks.add(() -> this.nsSummaryTaskWithOBS.reprocessWithOBS(this.reconOMMetadataManager));
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("Recon-NSSummaryTask-%d").build();
        ExecutorService executorService = Executors.newFixedThreadPool(3, threadFactory);
        boolean success = false;
        try {
            List results = executorService.invokeAll(tasks);
            for (Future result : results) {
                if (!((Boolean)result.get()).equals(false)) continue;
                LOG.error("NSSummary reprocess failed for one of the sub-tasks.");
                REBUILD_STATE.set(RebuildState.FAILED);
                ReconOmTask.TaskResult taskResult2 = this.buildTaskResult(false);
                return taskResult2;
            }
            success = true;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOG.error("NSSummaryTask was interrupted.", (Throwable)ex);
            REBUILD_STATE.set(RebuildState.FAILED);
            taskResult = this.buildTaskResult(false);
            return taskResult;
        }
        catch (ExecutionException ex) {
            LOG.error("Error while reprocessing NSSummary table in Recon DB.", ex.getCause());
            REBUILD_STATE.set(RebuildState.FAILED);
            taskResult = this.buildTaskResult(false);
            return taskResult;
        }
        finally {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
                    LOG.warn("Executor service for NSSummaryTask did not terminate in the specified time.");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                LOG.error("NSSummaryTask executor service termination was interrupted.", (Throwable)ex);
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
            long endTime = System.nanoTime();
            long durationInMillis = TimeUnit.NANOSECONDS.toMillis(endTime - startTime);
            LOG.info("NSSummary reprocess execution time: {} milliseconds", (Object)durationInMillis);
            if (success) {
                REBUILD_STATE.set(RebuildState.IDLE);
                LOG.info("NSSummary tree reprocess completed successfully with unified control.");
            }
        }
        return this.buildTaskResult(true);
    }

    @Override
    public ReconOmTask.TaskResult buildTaskResult(boolean success) {
        return new ReconOmTask.TaskResult.Builder().setTaskName(this.getTaskName()).setTaskSuccess(success).build();
    }

    @VisibleForTesting
    public static void resetRebuildState() {
        REBUILD_STATE.set(RebuildState.IDLE);
    }

    @VisibleForTesting
    public static void setRebuildStateToFailed() {
        REBUILD_STATE.set(RebuildState.FAILED);
    }

    public ReconNamespaceSummaryManager getReconNamespaceSummaryManager() {
        return this.reconNamespaceSummaryManager;
    }

    public static enum RebuildState {
        IDLE,
        RUNNING,
        FAILED;

    }

    public static enum BucketType {
        FSO("File System Optimized Bucket"),
        OBS("Object Store Bucket"),
        LEGACY("Legacy Bucket");

        private final String description;

        private BucketType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

