/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.ha.ConfUtils;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class SCMNodeInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SCMNodeInfo.class);
    private final String serviceId;
    private final String nodeId;
    private final String blockClientAddress;
    private final String scmClientAddress;
    private final String scmSecurityAddress;
    private final String scmDatanodeAddress;

    public static List<SCMNodeInfo> buildNodeInfo(ConfigurationSource conf) {
        ArrayList<SCMNodeInfo> scmNodeInfoList = new ArrayList<SCMNodeInfo>();
        String scmServiceId = HddsUtils.getScmServiceId(conf);
        if (scmServiceId != null) {
            ArrayList<String> scmNodeIds = new ArrayList<String>(HddsUtils.getSCMNodeIds(conf, scmServiceId));
            if (scmNodeIds.isEmpty()) {
                throw new ConfigurationException(String.format("Configuration does not have any value set for %s for the SCM serviceId %s. List of SCM Node ID's should be specified for an SCM HA service", "ozone.scm.nodes", scmServiceId));
            }
            for (String scmNodeId : scmNodeIds) {
                String addressKey = ConfUtils.addKeySuffixes("ozone.scm.address", scmServiceId, scmNodeId);
                String scmAddress = conf.get(addressKey);
                if (scmAddress == null) {
                    throw new ConfigurationException(addressKey + "is not defined");
                }
                int scmClientPort = SCMNodeInfo.getPort(conf, scmServiceId, scmNodeId, "ozone.scm.client.address", "ozone.scm.client.port", 9860);
                int scmBlockClientPort = SCMNodeInfo.getPort(conf, scmServiceId, scmNodeId, "ozone.scm.block.client.address", "ozone.scm.block.client.port", 9863);
                int scmSecurityPort = SCMNodeInfo.getPort(conf, scmServiceId, scmNodeId, "ozone.scm.security.service.address", "ozone.scm.security.service.port", 9961);
                int scmDatanodePort = SCMNodeInfo.getPort(conf, scmServiceId, scmNodeId, "ozone.scm.datanode.address", "ozone.scm.datanode.port", 9861);
                scmNodeInfoList.add(new SCMNodeInfo(scmServiceId, scmNodeId, SCMNodeInfo.buildAddress(scmAddress, scmBlockClientPort), SCMNodeInfo.buildAddress(scmAddress, scmClientPort), SCMNodeInfo.buildAddress(scmAddress, scmSecurityPort), SCMNodeInfo.buildAddress(scmAddress, scmDatanodePort)));
            }
            return scmNodeInfoList;
        }
        scmServiceId = "scmServiceId";
        String scmBlockClientAddress = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.block.client.address", "ozone.scm.client.address").orElse(null);
        String scmClientAddress = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.client.address").orElse(null);
        String scmSecurityClientAddress = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.security.service.address", "ozone.scm.client.address").orElse(null);
        String scmDatanodeAddress = HddsUtils.getHostNameFromConfigKeys(conf, "ozone.scm.datanode.address", "ozone.scm.client.address", "ozone.scm.names").orElse(null);
        int scmBlockClientPort = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.block.client.address").orElse(conf.getInt("ozone.scm.block.client.port", 9863));
        int scmClientPort = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.client.address").orElse(conf.getInt("ozone.scm.client.port", 9860));
        int scmSecurityPort = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.security.service.address").orElse(conf.getInt("ozone.scm.security.service.port", 9961));
        int scmDatanodePort = HddsUtils.getPortNumberFromConfigKeys(conf, "ozone.scm.datanode.address").orElse(conf.getInt("ozone.scm.datanode.port", 9861));
        scmNodeInfoList.add(new SCMNodeInfo(scmServiceId, "scmNodeId", scmBlockClientAddress == null ? null : SCMNodeInfo.buildAddress(scmBlockClientAddress, scmBlockClientPort), scmClientAddress == null ? null : SCMNodeInfo.buildAddress(scmClientAddress, scmClientPort), scmSecurityClientAddress == null ? null : SCMNodeInfo.buildAddress(scmSecurityClientAddress, scmSecurityPort), scmDatanodeAddress == null ? null : SCMNodeInfo.buildAddress(scmDatanodeAddress, scmDatanodePort)));
        return scmNodeInfoList;
    }

    private static String buildAddress(String address, int port) {
        return address + ':' + port;
    }

    private static int getPort(ConfigurationSource conf, String scmServiceId, String scmNodeId, String configKey, String portKey, int defaultPort) {
        String suffixKey = ConfUtils.addKeySuffixes(configKey, scmServiceId, scmNodeId);
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys(conf, suffixKey);
        if (port.isPresent()) {
            LOG.info("ConfigKey {} is deprecated, For configuring different ports for each SCM use PortConfigKey {} appended with serviceId and nodeId", (Object)configKey, (Object)portKey);
            return port.getAsInt();
        }
        return conf.getInt(ConfUtils.addKeySuffixes(portKey, scmServiceId, scmNodeId), conf.getInt(portKey, defaultPort));
    }

    public SCMNodeInfo(String serviceId, String nodeId, String blockClientAddress, String scmClientAddress, String scmSecurityAddress, String scmDatanodeAddress) {
        this.serviceId = serviceId;
        this.nodeId = nodeId;
        this.blockClientAddress = blockClientAddress;
        this.scmClientAddress = scmClientAddress;
        this.scmSecurityAddress = scmSecurityAddress;
        this.scmDatanodeAddress = scmDatanodeAddress;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getBlockClientAddress() {
        return this.blockClientAddress;
    }

    public String getScmClientAddress() {
        return this.scmClientAddress;
    }

    public String getScmSecurityAddress() {
        return this.scmSecurityAddress;
    }

    public String getScmDatanodeAddress() {
        return this.scmDatanodeAddress;
    }
}

