/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.net.InnerNode;
import org.apache.hadoop.hdds.scm.net.NetConstants;
import org.apache.hadoop.hdds.scm.net.NetUtils;
import org.apache.hadoop.hdds.scm.net.Node;
import org.apache.hadoop.ozone.util.StringWithByteString;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;

public class NodeImpl
implements Node {
    private StringWithByteString name;
    private StringWithByteString location;
    private String path;
    private int level;
    private InnerNode parent;
    private final int cost;

    public NodeImpl(StringWithByteString name, StringWithByteString location, int cost) {
        if (name != null && name.getString().contains("/")) {
            throw new IllegalArgumentException("Network location name:" + name + " should not contain " + "/");
        }
        this.name = name == null ? NetConstants.BYTE_STRING_ROOT : name;
        this.location = location;
        this.path = this.getPath();
        this.cost = cost;
    }

    public NodeImpl(String name, String location, int cost) {
        this(StringWithByteString.valueOf(name), StringWithByteString.valueOf(NetUtils.normalize(location)), cost);
    }

    public NodeImpl(String name, String location, InnerNode parent, int level, int cost) {
        this(name, location, cost);
        this.parent = parent;
        this.level = level;
    }

    public NodeImpl(StringWithByteString name, StringWithByteString location, InnerNode parent, int level, int cost) {
        this(name, location, cost);
        this.parent = parent;
        this.level = level;
    }

    @Override
    public String getNetworkName() {
        return this.name.getString();
    }

    public StringWithByteString getNetworkNameAsByteString() {
        return this.name;
    }

    @Override
    public void setNetworkName(String networkName) {
        this.name = StringWithByteString.valueOf(networkName);
        this.path = this.getPath();
    }

    public void setNetworkName(StringWithByteString networkName) {
        this.name = networkName;
        this.path = this.getPath();
    }

    @Override
    public String getNetworkLocation() {
        return this.location.getString();
    }

    public StringWithByteString getNetworkLocationAsByteString() {
        return this.location;
    }

    @Override
    public void setNetworkLocation(String networkLocation) {
        this.location = StringWithByteString.valueOf(networkLocation);
        this.path = this.getPath();
    }

    @Override
    public String getNetworkFullPath() {
        return this.path;
    }

    @Override
    public InnerNode getParent() {
        return this.parent;
    }

    @Override
    public Node getAncestor(int generation) {
        Node current;
        Preconditions.checkArgument(generation >= 0);
        for (current = this; generation > 0 && current != null; current = current.getParent(), --generation) {
        }
        return current;
    }

    @Override
    public void setParent(InnerNode parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    @Override
    public int getNumOfLeaves() {
        return 1;
    }

    @Override
    public boolean isAncestor(Node node) {
        if (node == null) {
            return false;
        }
        return this.isAncestor(node.getNetworkFullPath());
    }

    @Override
    public boolean isAncestor(String nodePath) {
        if (nodePath == null) {
            return false;
        }
        return this.getNetworkFullPath().equals("/") || nodePath.equalsIgnoreCase(this.getNetworkFullPath()) || NetUtils.addSuffix(nodePath).startsWith(NetUtils.addSuffix(this.getNetworkFullPath()));
    }

    @Override
    public boolean isDescendant(Node node) {
        if (node == null) {
            return false;
        }
        return this.isDescendant(node.getNetworkFullPath());
    }

    @Override
    public boolean isDescendant(String nodePath) {
        if (nodePath == null) {
            return false;
        }
        return NetUtils.addSuffix(this.getNetworkFullPath()).startsWith(NetUtils.addSuffix(nodePath));
    }

    public static HddsProtos.NodeTopology toProtobuf(String name, String location, int level, int cost) {
        HddsProtos.NodeTopology.Builder nodeTopologyBuilder = HddsProtos.NodeTopology.newBuilder().setName(name).setLocation(location).setLevel(level).setCost(cost);
        HddsProtos.NodeTopology nodeTopology = nodeTopologyBuilder.build();
        return nodeTopology;
    }

    public boolean equals(Object to) {
        if (to == null) {
            return false;
        }
        if (this == to) {
            return true;
        }
        return this.toString().equals(to.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getNetworkFullPath();
    }

    private String getPath() {
        return this.location.getString().equals("/") ? this.location + this.name.getString() : this.location + "/" + this.name;
    }
}

