/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedFunction;
import org.apache.ozone.shaded.org.bouncycastle.util.io.pem.PemObject;
import org.apache.ozone.shaded.org.bouncycastle.util.io.pem.PemReader;
import org.apache.ozone.shaded.org.bouncycastle.util.io.pem.PemWriter;

public class KeyCodec {
    private static final int BUFFER_LEN = 8192;
    private final KeyFactory keyFactory;

    public KeyCodec(String keyAlgorithm) throws NoSuchAlgorithmException {
        this.keyFactory = KeyFactory.getInstance(keyAlgorithm);
    }

    public byte[] encodePublicKey(PublicKey key) throws IOException {
        return this.encodeKey("PUBLIC KEY", key);
    }

    public byte[] encodePrivateKey(PrivateKey key) throws IOException {
        return this.encodeKey("PRIVATE KEY", key);
    }

    public PrivateKey decodePrivateKey(byte[] encodedKey) throws IOException {
        return this.decodeKey(encodedKey, this.keyFactory::generatePrivate);
    }

    public PublicKey decodePublicKey(byte[] encodedKey) throws IOException {
        return this.decodeKey(encodedKey, ks -> this.keyFactory.generatePublic(new X509EncodedKeySpec(ks.getEncoded())));
    }

    private byte[] encodeKey(String keyType, Key key) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream(8192);
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)bytes, StandardCharsets.US_ASCII);){
            byte[] byArray;
            try (PemWriter pemWriter = new PemWriter(w);){
                pemWriter.writeObject(new PemObject(keyType, key.getEncoded()));
                pemWriter.flush();
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T decodeKey(byte[] encodedKey, CheckedFunction<PKCS8EncodedKeySpec, T, InvalidKeySpecException> generator) throws IOException {
        try (PemReader pemReader = new PemReader(new InputStreamReader((InputStream)new ByteArrayInputStream(encodedKey), StandardCharsets.US_ASCII));){
            PemObject keyObject = pemReader.readPemObject();
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyObject.getContent());
            T t2 = generator.apply(pkcs8EncodedKeySpec);
            return t2;
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }
}

