/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.tracing.TracingUtil;

public class TraceAllMethod<T>
implements InvocationHandler {
    private final Map<String, Map<Class<?>[], Method>> methods = new HashMap<String, Map<Class<?>[], Method>>();
    private final T delegate;
    private final String name;

    public TraceAllMethod(T delegate, String name) {
        this.delegate = delegate;
        this.name = name;
        for (Method method : delegate.getClass().getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            this.methods.computeIfAbsent(method.getName(), any -> new HashMap()).put(method.getParameterTypes(), method);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        Method delegateMethod = this.findDelegatedMethod(method);
        if (delegateMethod == null) {
            throw new NoSuchMethodException("Method not found: " + method.getName());
        }
        TracingUtil.TraceCloseable ignored = TracingUtil.createActivatedSpan(this.name + "." + method.getName());
        try {
            Object object = delegateMethod.invoke(this.delegate, args2);
            return object;
        }
        catch (Exception ex) {
            if (ex.getCause() != null) {
                throw ex.getCause();
            }
            throw ex;
        }
        finally {
            if (ignored != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private Method findDelegatedMethod(Method method) {
        for (Map.Entry entry : this.methods.getOrDefault(method.getName(), Collections.emptyMap()).entrySet()) {
            if (!Arrays.equals((Object[])entry.getKey(), method.getParameterTypes())) continue;
            return (Method)entry.getValue();
        }
        return null;
    }
}

