/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;

@ConfigGroup(prefix="ozone.om")
public class OmConfig
extends ReconfigurableConfig {
    @Config(key="enable.filesystem.paths", defaultValue="false", description="If true, key names will be interpreted as file system paths. '/' will be treated as a special character and paths will be normalized and must follow Unix filesystem path naming conventions. This flag will be helpful when objects created by S3G need to be accessed using OFS/O3Fs. If false, it will fallback to default behavior of Key/MPU create requests where key paths are not normalized and any intermediate directories will not be created or any file checks happens to check filesystem semantics.", tags={ConfigTag.OM, ConfigTag.OZONE})
    private boolean fileSystemPathEnabled;
    @Config(key="ozone.om.keyname.character.check.enabled", defaultValue="false", description="If true, then enable to check if the key name contains illegal characters when creating/renaming key. For the definition of illegal characters, follow the rules in Amazon S3's object key naming guide.", tags={ConfigTag.OM, ConfigTag.OZONE})
    private boolean keyNameCharacterCheckEnabled;
    @Config(key="server.list.max.size", defaultValue="1000", description="Configuration property to configure the max server side response size for list calls on om.", reconfigurable=true, tags={ConfigTag.OM, ConfigTag.OZONE})
    private long maxListSize;
    @Config(key="user.max.volume", defaultValue="1024", description="The maximum number of volumes a user can have on a cluster.Increasing or decreasing this number has no real impact on ozone cluster. This is defined only for operational purposes. Only an administrator can create a volume, once a volume is created there are no restrictions on the number of buckets or keys inside each bucket a user can create.", tags={ConfigTag.OM, ConfigTag.MANAGEMENT})
    private int maxUserVolumeCount;
    @Config(key="upgrade.finalization.ratis.based.timeout", defaultValue="30s", type=ConfigType.TIME, tags={ConfigTag.OM, ConfigTag.UPGRADE}, description="Maximum time to wait for a slow follower to be finalized through a Ratis snapshot. This is an advanced config, and needs to be changed only under a special circumstance when the leader OM has purged the finalize request from its logs, and a follower OM was down during upgrade finalization. Default is 30s.")
    private long ratisBasedFinalizationTimeout = Duration.ofSeconds(30L).getSeconds();
    @Config(key="user.rights", defaultValue="ALL", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default user permissions set for an object in OzoneManager.")
    private String userDefaultRights;
    private Set<IAccessAuthorizer.ACLType> userDefaultRightSet;
    @Config(key="group.rights", defaultValue="READ, LIST", type=ConfigType.STRING, tags={ConfigTag.OM, ConfigTag.SECURITY}, description="Default group permissions set for an object in OzoneManager.")
    private String groupDefaultRights;
    private Set<IAccessAuthorizer.ACLType> groupDefaultRightSet;

    public long getRatisBasedFinalizationTimeout() {
        return this.ratisBasedFinalizationTimeout;
    }

    public boolean isFileSystemPathEnabled() {
        return this.fileSystemPathEnabled;
    }

    public void setFileSystemPathEnabled(boolean newValue) {
        this.fileSystemPathEnabled = newValue;
    }

    public boolean isKeyNameCharacterCheckEnabled() {
        return this.keyNameCharacterCheckEnabled;
    }

    public void setKeyNameCharacterCheckEnabled(boolean newValue) {
        this.keyNameCharacterCheckEnabled = newValue;
    }

    public long getMaxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(long newValue) {
        this.maxListSize = newValue;
        this.validate();
    }

    public int getMaxUserVolumeCount() {
        return this.maxUserVolumeCount;
    }

    public void setMaxUserVolumeCount(int newValue) {
        this.maxUserVolumeCount = newValue;
        this.validate();
    }

    public Set<IAccessAuthorizer.ACLType> getUserDefaultRights() {
        if (this.userDefaultRightSet == null) {
            this.userDefaultRightSet = this.getUserDefaultRightSet();
        }
        return this.userDefaultRightSet;
    }

    private Set<IAccessAuthorizer.ACLType> getUserDefaultRightSet() {
        return this.userDefaultRights == null ? Collections.singleton(IAccessAuthorizer.ACLType.ALL) : IAccessAuthorizer.ACLType.parseList(this.userDefaultRights);
    }

    public Set<IAccessAuthorizer.ACLType> getGroupDefaultRights() {
        if (this.groupDefaultRightSet == null) {
            this.groupDefaultRightSet = this.getGroupDefaultRightSet();
        }
        return this.groupDefaultRightSet;
    }

    private Set<IAccessAuthorizer.ACLType> getGroupDefaultRightSet() {
        return this.groupDefaultRights == null ? Collections.unmodifiableSet(EnumSet.of(IAccessAuthorizer.ACLType.READ, IAccessAuthorizer.ACLType.LIST)) : IAccessAuthorizer.ACLType.parseList(this.groupDefaultRights);
    }

    @PostConstruct
    public void validate() {
        if (this.maxListSize <= 0L) {
            this.maxListSize = 1000L;
        }
        Preconditions.checkArgument(this.maxUserVolumeCount > 0, "ozone.om.user.max.volume value should be greater than zero");
        this.userDefaultRightSet = this.getUserDefaultRightSet();
        this.groupDefaultRightSet = this.getGroupDefaultRightSet();
    }

    public OmConfig copy() {
        OmConfig copy = new OmConfig();
        copy.setFrom(this);
        return copy;
    }

    public void setFrom(OmConfig other) {
        this.fileSystemPathEnabled = other.fileSystemPathEnabled;
        this.keyNameCharacterCheckEnabled = other.keyNameCharacterCheckEnabled;
        this.maxListSize = other.maxListSize;
        this.maxUserVolumeCount = other.maxUserVolumeCount;
        this.userDefaultRights = other.userDefaultRights;
        this.groupDefaultRights = other.groupDefaultRights;
        this.validate();
    }

    public static final class Defaults {
        public static final boolean ENABLE_FILESYSTEM_PATHS = false;
        public static final long SERVER_LIST_MAX_SIZE = 1000L;
    }

    public static final class Keys {
        public static final String ENABLE_FILESYSTEM_PATHS = "ozone.om.enable.filesystem.paths";
        public static final String SERVER_LIST_MAX_SIZE = "ozone.om.server.list.max.size";
        public static final String USER_MAX_VOLUME = "ozone.om.user.max.volume";
    }
}

