/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.net.InetAddress;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;

@Immutable
public class AssumeRoleRequest {
    private final String host;
    private final InetAddress ip;
    private final UserGroupInformation clientUgi;
    private final String targetRoleName;
    private final Set<OzoneGrant> grants;

    public AssumeRoleRequest(String host, InetAddress ip, UserGroupInformation clientUgi, String targetRoleName, Set<OzoneGrant> grants) {
        this.host = host;
        this.ip = ip;
        this.clientUgi = clientUgi;
        this.targetRoleName = targetRoleName;
        this.grants = grants;
    }

    public String getHost() {
        return this.host;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public UserGroupInformation getClientUgi() {
        return this.clientUgi;
    }

    public String getTargetRoleName() {
        return this.targetRoleName;
    }

    public Set<OzoneGrant> getGrants() {
        return this.grants;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssumeRoleRequest that = (AssumeRoleRequest)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.ip, that.ip) && Objects.equals(this.clientUgi, that.clientUgi) && Objects.equals(this.targetRoleName, that.targetRoleName) && Objects.equals(this.grants, that.grants);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ip, this.clientUgi, this.targetRoleName, this.grants);
    }

    @Immutable
    public static class OzoneGrant {
        private final Set<IOzoneObj> objects;
        private final Set<IAccessAuthorizer.ACLType> permissions;

        public OzoneGrant(Set<IOzoneObj> objects, Set<IAccessAuthorizer.ACLType> permissions) {
            this.objects = objects;
            this.permissions = permissions;
        }

        public Set<IOzoneObj> getObjects() {
            return this.objects;
        }

        public Set<IAccessAuthorizer.ACLType> getPermissions() {
            return this.permissions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OzoneGrant that = (OzoneGrant)o;
            return Objects.equals(this.objects, that.objects) && Objects.equals(this.permissions, that.permissions);
        }

        public int hashCode() {
            return Objects.hash(this.objects, this.permissions);
        }
    }
}

