/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Proto2Utils;
import org.apache.ozone.shaded.org.apache.commons.lang3.RandomUtils;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;

public final class PayloadUtils {
    private static final int MAX_SIZE = 2147482624;
    private static final byte[] SEED = RandomUtils.secure().randomBytes(1024);

    private PayloadUtils() {
    }

    public static byte[] generatePayload(int payloadSizeBytes) {
        int curIdx;
        int copySize;
        byte[] result2 = new byte[Math.min(payloadSizeBytes, 2147482624)];
        for (curIdx = 0; curIdx < result2.length; curIdx += copySize) {
            int remaining = result2.length - curIdx;
            copySize = Math.min(SEED.length, remaining);
            System.arraycopy(SEED, 0, result2, curIdx, copySize);
        }
        Preconditions.assertTrue(curIdx == result2.length);
        return result2;
    }

    public static ByteString generatePayloadProto2(int payloadSizeBytes) {
        return Proto2Utils.unsafeByteString(PayloadUtils.generatePayload(payloadSizeBytes));
    }

    public static org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString generatePayloadProto3(int payloadSizeBytes) {
        return UnsafeByteOperations.unsafeWrap(PayloadUtils.generatePayload(payloadSizeBytes));
    }
}

