/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.com.google.common.primitives;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.ozone.shaded.com.google.common.annotations.GwtIncompatible;
import org.apache.ozone.shaded.com.google.common.annotations.J2ktIncompatible;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.com.google.common.primitives.IgnoreJRERequirement;
import org.apache.ozone.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.ozone.shaded.com.google.errorprone.annotations.InlineMe;
import org.apache.ozone.shaded.org.jspecify.annotations.Nullable;
import sun.misc.Unsafe;

@J2ktIncompatible
@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    @InlineMe(replacement="Byte.toUnsignedInt(value)")
    public static int toInt(byte value) {
        return Byte.toUnsignedInt(value);
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > (long)Byte.toUnsignedInt((byte)-1)) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a, byte b) {
        return Byte.toUnsignedInt(a) - Byte.toUnsignedInt(b);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min2 = Byte.toUnsignedInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = Byte.toUnsignedInt(array[i]);
            if (next >= min2) continue;
            min2 = next;
        }
        return (byte)min2;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = Byte.toUnsignedInt(array[0]);
        for (int i = 1; i < array.length; ++i) {
            int next = Byte.toUnsignedInt(array[i]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String toString(byte x) {
        return UnsignedBytes.toString(x, 10);
    }

    public static String toString(byte x, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        return Integer.toString(Byte.toUnsignedInt(x), radix);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int radix) {
        int parse = Integer.parseInt(Preconditions.checkNotNull(string), radix);
        if (parse >> 8 == 0) {
            return (byte)parse;
        }
        throw new NumberFormatException("out of range: " + parse);
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * (3 + separator.length()));
        builder.append(Byte.toUnsignedInt(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedBytes.toString(array[i]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte b) {
        return (byte)(b ^ 0x80);
    }

    public static void sort(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sort(array, 0, array.length);
    }

    public static void sort(byte[] array, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedBytes.flip(array[i]);
        }
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull(array);
        UnsignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
        Arrays.sort(array, fromIndex, toIndex);
        i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = (byte)(array[n] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static final class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        static Comparator<byte[]> getBestComparator() {
            Comparator<byte[]> arraysCompareUnsignedComparator = ArraysCompareUnsignedComparatorMaker.INSTANCE.tryMakeArraysCompareUnsignedComparator();
            if (arraysCompareUnsignedComparator != null) {
                return arraysCompareUnsignedComparator;
            }
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                ?[] constants = Objects.requireNonNull(theClass.getEnumConstants());
                Comparator comparator = (Comparator)constants[0];
                return comparator;
            }
            catch (Throwable t2) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        private LexicographicalComparatorHolder() {
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i = 0; i < minLength; ++i) {
                    int result2 = UnsignedBytes.compare(left[i], right[i]);
                    if (result2 == 0) continue;
                    return result2;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(() -> {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : k.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw new RuntimeException("Could not initialize intrinsics", e.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] left, byte[] right) {
                int i;
                int stride = 8;
                int minLength = Math.min(left.length, right.length);
                int strideLimit = minLength & ~(stride - 1);
                for (i = 0; i < strideLimit; i += stride) {
                    long rw;
                    long lw = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i);
                    if (lw == (rw = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i))) continue;
                    if (BIG_ENDIAN) {
                        return Long.compareUnsigned(lw, rw);
                    }
                    int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
                    return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
                }
                while (i < minLength) {
                    int result2 = UnsignedBytes.compare(left[i], right[i]);
                    if (result2 != 0) {
                        return result2;
                    }
                    ++i;
                }
                return left.length - right.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!Objects.equals(System.getProperty("sun.arch.data.model"), "64") || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }

    static enum ArraysCompareUnsignedComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        @IgnoreJRERequirement
        public int compare(byte[] left, byte[] right) {
            return Arrays.compareUnsigned(left, right);
        }
    }

    private static enum ArraysCompareUnsignedComparatorMaker {
        INSTANCE{

            @Override
            @IgnoreJRERequirement
            @Nullable Comparator<byte[]> tryMakeArraysCompareUnsignedComparator() {
                try {
                    Arrays.class.getMethod("org.apache.ozone.shaded.compareUnsigned", byte[].class, byte[].class);
                }
                catch (NoSuchMethodException beforeJava9) {
                    return null;
                }
                return ArraysCompareUnsignedComparator.INSTANCE;
            }
        };


        @Nullable Comparator<byte[]> tryMakeArraysCompareUnsignedComparator() {
            return null;
        }
    }
}

