/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;

public class ExponentialHistogramBucketsMarshaler
extends MarshalerWithSize {
    private final int offset;
    private final List<Long> counts;

    static ExponentialHistogramBucketsMarshaler create(ExponentialHistogramBuckets buckets) {
        return new ExponentialHistogramBucketsMarshaler(buckets.getOffset(), buckets.getBucketCounts());
    }

    private ExponentialHistogramBucketsMarshaler(int offset, List<Long> counts) {
        super(ExponentialHistogramBucketsMarshaler.calculateSize(offset, counts));
        this.offset = offset;
        this.counts = counts;
    }

    @Override
    protected void writeTo(Serializer output) throws IOException {
        output.serializeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, this.offset);
        if (this.counts instanceof DynamicPrimitiveLongList) {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, (DynamicPrimitiveLongList)this.counts);
        } else {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(this.counts));
        }
    }

    static int calculateSize(int offset, List<Long> counts) {
        int size = 0;
        size += MarshalerUtil.sizeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, offset);
        size = counts instanceof DynamicPrimitiveLongList ? (size += MarshalerUtil.sizeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, (DynamicPrimitiveLongList)counts)) : (size += MarshalerUtil.sizeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(counts)));
        return size;
    }
}

