/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.internal;

import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.ozone.shaded.io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;

public class OtlpMetricExporterProvider
implements ConfigurableMetricExporterProvider {
    @Override
    public MetricExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpMetricExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setComponentLoader, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            ExporterBuilderUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            ExporterBuilderUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcMetricExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, builder::setComponentLoader, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            ExporterBuilderUtil.configureOtlpAggregationTemporality(config, builder::setAggregationTemporalitySelector);
            ExporterBuilderUtil.configureOtlpHistogramDefaultAggregation(config, builder::setDefaultAggregationSelector);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpMetricExporterBuilder httpBuilder() {
        return OtlpHttpMetricExporter.builder();
    }

    OtlpGrpcMetricExporterBuilder grpcBuilder() {
        return OtlpGrpcMetricExporter.builder();
    }
}

