/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.base.Objects;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ConnectivityState;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ConnectivityStateInfo;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.ExperimentalApi;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.LoadBalancer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.LoadBalancerRegistry;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.NameResolver;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.internal.ServiceConfigUtil;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util.ForwardingLoadBalancer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.grpc.util.ForwardingLoadBalancerHelper;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5999")
@NotThreadSafe
public final class GracefulSwitchLoadBalancer
extends ForwardingLoadBalancer {
    private final LoadBalancer defaultBalancer;
    @VisibleForTesting
    static final LoadBalancer.SubchannelPicker BUFFER_PICKER = new LoadBalancer.SubchannelPicker(){

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args2) {
            return LoadBalancer.PickResult.withNoResult();
        }

        public String toString() {
            return "BUFFER_PICKER";
        }
    };
    private final LoadBalancer.Helper helper;
    @Nullable
    private LoadBalancer.Factory currentBalancerFactory;
    private LoadBalancer currentLb;
    @Nullable
    private LoadBalancer.Factory pendingBalancerFactory;
    private LoadBalancer pendingLb;
    private ConnectivityState pendingState;
    private LoadBalancer.SubchannelPicker pendingPicker;
    private boolean switchToCalled;
    private boolean currentLbIsReady;

    public GracefulSwitchLoadBalancer(LoadBalancer.Helper helper) {
        this.currentLb = this.defaultBalancer = new LoadBalancer(){

            @Override
            public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                throw new IllegalStateException("GracefulSwitchLoadBalancer must switch to a load balancing policy before handling ResolvedAddresses");
            }

            @Override
            public void handleNameResolutionError(Status error) {
                GracefulSwitchLoadBalancer.this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
            }

            @Override
            public void shutdown() {
            }
        };
        this.pendingLb = this.defaultBalancer;
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    @Override
    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.switchToCalled) {
            this.delegate().handleResolvedAddresses(resolvedAddresses);
            return;
        }
        Config config = (Config)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.switchToInternal(config.childFactory);
        this.delegate().handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childConfig).build());
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.switchToCalled) {
            return this.delegate().acceptResolvedAddresses(resolvedAddresses);
        }
        Config config = (Config)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.switchToInternal(config.childFactory);
        return this.delegate().acceptResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(config.childConfig).build());
    }

    @Deprecated
    public void switchTo(LoadBalancer.Factory newBalancerFactory) {
        this.switchToCalled = true;
        this.switchToInternal(newBalancerFactory);
    }

    private void switchToInternal(LoadBalancer.Factory newBalancerFactory) {
        Preconditions.checkNotNull(newBalancerFactory, "newBalancerFactory");
        if (newBalancerFactory.equals(this.pendingBalancerFactory)) {
            return;
        }
        this.pendingLb.shutdown();
        this.pendingLb = this.defaultBalancer;
        this.pendingBalancerFactory = null;
        this.pendingState = ConnectivityState.CONNECTING;
        this.pendingPicker = BUFFER_PICKER;
        if (newBalancerFactory.equals(this.currentBalancerFactory)) {
            return;
        }
        class PendingHelper
        extends ForwardingLoadBalancerHelper {
            LoadBalancer lb;

            PendingHelper() {
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return GracefulSwitchLoadBalancer.this.helper;
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (this.lb == GracefulSwitchLoadBalancer.this.pendingLb) {
                    Preconditions.checkState(GracefulSwitchLoadBalancer.this.currentLbIsReady, "there's pending lb while current lb has been out of READY");
                    GracefulSwitchLoadBalancer.this.pendingState = newState;
                    GracefulSwitchLoadBalancer.this.pendingPicker = newPicker;
                    if (newState == ConnectivityState.READY) {
                        GracefulSwitchLoadBalancer.this.swap();
                    }
                } else if (this.lb == GracefulSwitchLoadBalancer.this.currentLb) {
                    GracefulSwitchLoadBalancer.this.currentLbIsReady = newState == ConnectivityState.READY;
                    if (!GracefulSwitchLoadBalancer.this.currentLbIsReady && GracefulSwitchLoadBalancer.this.pendingLb != GracefulSwitchLoadBalancer.this.defaultBalancer) {
                        GracefulSwitchLoadBalancer.this.swap();
                    } else {
                        GracefulSwitchLoadBalancer.this.helper.updateBalancingState(newState, newPicker);
                    }
                }
            }
        }
        PendingHelper pendingHelper = new PendingHelper();
        this.pendingLb = pendingHelper.lb = newBalancerFactory.newLoadBalancer(pendingHelper);
        this.pendingBalancerFactory = newBalancerFactory;
        if (!this.currentLbIsReady) {
            this.swap();
        }
    }

    private void swap() {
        this.helper.updateBalancingState(this.pendingState, this.pendingPicker);
        this.currentLb.shutdown();
        this.currentLb = this.pendingLb;
        this.currentBalancerFactory = this.pendingBalancerFactory;
        this.pendingLb = this.defaultBalancer;
        this.pendingBalancerFactory = null;
    }

    @Override
    protected LoadBalancer delegate() {
        return this.pendingLb == this.defaultBalancer ? this.currentLb : this.pendingLb;
    }

    @Override
    @Deprecated
    public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        throw new UnsupportedOperationException("handleSubchannelState() is not supported by " + this.getClass().getName());
    }

    @Override
    public void shutdown() {
        this.pendingLb.shutdown();
        this.currentLb.shutdown();
    }

    public String delegateType() {
        return this.delegate().getClass().getSimpleName();
    }

    public static NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(List<Map<String, ?>> loadBalancingConfigs) {
        return GracefulSwitchLoadBalancer.parseLoadBalancingPolicyConfig(loadBalancingConfigs, LoadBalancerRegistry.getDefaultRegistry());
    }

    public static NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(List<Map<String, ?>> loadBalancingConfigs, LoadBalancerRegistry lbRegistry) {
        List<ServiceConfigUtil.LbConfig> childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList(loadBalancingConfigs);
        if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription("No child LB config specified"));
        }
        NameResolver.ConfigOrError selectedConfig = ServiceConfigUtil.selectLbPolicyFromList(childConfigCandidates, lbRegistry);
        if (selectedConfig.getError() != null) {
            Status error = selectedConfig.getError();
            return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withCause(error.getCause()).withDescription(error.getDescription()).augmentDescription("Failed to select child config"));
        }
        ServiceConfigUtil.PolicySelection selection = (ServiceConfigUtil.PolicySelection)selectedConfig.getConfig();
        return NameResolver.ConfigOrError.fromConfig(GracefulSwitchLoadBalancer.createLoadBalancingPolicyConfig(selection.getProvider(), selection.getConfig()));
    }

    public static Object createLoadBalancingPolicyConfig(LoadBalancer.Factory childFactory, @Nullable Object childConfig) {
        return new Config(childFactory, childConfig);
    }

    static final class Config {
        final LoadBalancer.Factory childFactory;
        @Nullable
        final Object childConfig;

        public Config(LoadBalancer.Factory childFactory, @Nullable Object childConfig) {
            this.childFactory = Preconditions.checkNotNull(childFactory, "childFactory");
            this.childConfig = childConfig;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config that = (Config)o;
            return Objects.equal(this.childFactory, that.childFactory) && Objects.equal(this.childConfig, that.childConfig);
        }

        public int hashCode() {
            return Objects.hashCode(this.childFactory, this.childConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper("GracefulSwitchLoadBalancer.Config").add("childFactory", this.childFactory).add("childConfig", this.childConfig).toString();
        }
    }
}

