/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.container;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.cli.container.ContainerIDParameters;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplicaInfo;
import org.apache.hadoop.hdds.server.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="reconcile", description={"Reconcile container replicas"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ReconcileSubcommand
extends ScmSubcommand {
    @CommandLine.Mixin
    private ContainerIDParameters containerList;
    @CommandLine.Option(names={"--status"}, defaultValue="false", fallbackValue="true", description={"Display the reconciliation status of this container's replicas"})
    private boolean status;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        if (this.status) {
            this.executeStatus(scmClient);
        } else {
            this.executeReconcile(scmClient);
        }
    }

    private void executeStatus(ScmClient scmClient) throws IOException {
        List<Long> containerIDs = this.containerList.getValidatedIDs();
        int failureCount = 0;
        StringBuilder errorBuilder = new StringBuilder();
        try (SequenceWriter arrayWriter = JsonUtils.getStdoutSequenceWriter();){
            for (Long containerID : containerIDs) {
                if (this.printReconciliationStatus(scmClient, containerID, arrayWriter, errorBuilder)) continue;
                ++failureCount;
            }
            arrayWriter.flush();
        }
        System.out.println();
        System.out.flush();
        if (errorBuilder.length() > 0) {
            System.err.print(errorBuilder);
        }
        if (failureCount > 0) {
            throw new RuntimeException("Failed to process reconciliation status for " + failureCount + " container" + (failureCount > 1 ? "s" : ""));
        }
    }

    private boolean printReconciliationStatus(ScmClient scmClient, long containerID, SequenceWriter arrayWriter, StringBuilder errorBuilder) {
        try {
            ContainerInfo containerInfo = scmClient.getContainer(containerID);
            if (containerInfo.isOpen()) {
                errorBuilder.append("Cannot get status of container ").append(containerID).append(". Reconciliation is not supported for open containers\n");
                return false;
            }
            if (containerInfo.getReplicationType() != HddsProtos.ReplicationType.RATIS) {
                errorBuilder.append("Cannot get status of container ").append(containerID).append(". Reconciliation is only supported for Ratis replicated containers\n");
                return false;
            }
            List replicas = scmClient.getContainerReplicas(containerID);
            arrayWriter.write((Object)new ContainerWrapper(containerInfo, replicas));
            arrayWriter.flush();
        }
        catch (Exception ex) {
            errorBuilder.append("Failed to get reconciliation status of container ").append(containerID).append(": ").append(this.getExceptionMessage(ex)).append('\n');
            return false;
        }
        return true;
    }

    private void executeReconcile(ScmClient scmClient) {
        int failureCount = 0;
        int successCount = 0;
        for (Long containerID : this.containerList.getValidatedIDs()) {
            try {
                scmClient.reconcileContainer(containerID.longValue());
                System.out.println("Reconciliation has been triggered for container " + containerID);
                ++successCount;
            }
            catch (Exception ex) {
                System.err.println("Failed to trigger reconciliation for container " + containerID + ": " + this.getExceptionMessage(ex));
                ++failureCount;
            }
        }
        if (successCount > 0) {
            System.out.println("\nUse \"ozone admin container reconcile --status\" to see the checksums of each container replica");
        }
        if (failureCount > 0) {
            throw new RuntimeException("Failed to trigger reconciliation for " + failureCount + " container" + (failureCount > 1 ? "s" : ""));
        }
    }

    private String getExceptionMessage(Exception ex) {
        return ex.getMessage().split("\n", 2)[0];
    }

    private static class ContainerWrapper {
        private final long containerID;
        private final HddsProtos.LifeCycleState state;
        private final ReplicationConfig replicationConfig;
        private boolean replicasMatch;
        private final List<ReplicaWrapper> replicas;

        ContainerWrapper(ContainerInfo info, List<ContainerReplicaInfo> replicas) {
            this.containerID = info.getContainerID();
            this.state = info.getState();
            this.replicationConfig = info.getReplicationConfig();
            this.replicas = new ArrayList<ReplicaWrapper>();
            this.replicasMatch = true;
            long firstChecksum = 0L;
            if (!replicas.isEmpty()) {
                firstChecksum = replicas.get(0).getDataChecksum();
            }
            for (ContainerReplicaInfo replica : replicas) {
                this.replicasMatch = this.replicasMatch && firstChecksum == replica.getDataChecksum();
                this.replicas.add(new ReplicaWrapper(replica));
            }
        }

        public long getContainerID() {
            return this.containerID;
        }

        public HddsProtos.LifeCycleState getState() {
            return this.state;
        }

        public ReplicationConfig getReplicationConfig() {
            return this.replicationConfig;
        }

        public boolean getReplicasMatch() {
            return this.replicasMatch;
        }

        public List<ReplicaWrapper> getReplicas() {
            return this.replicas;
        }
    }

    private static class DatanodeWrapper {
        private final DatanodeDetails dnDetails;

        DatanodeWrapper(DatanodeDetails dnDetails) {
            this.dnDetails = dnDetails;
        }

        @JsonProperty(index=5)
        public String getID() {
            return this.dnDetails.getUuidString();
        }

        @JsonProperty(index=10)
        public String getHostname() {
            return this.dnDetails.getHostName();
        }

        @JsonProperty(index=15, value="ipAddress")
        public String getIPAddress() {
            return this.dnDetails.getIpAddress();
        }
    }

    private static class ReplicaWrapper {
        private final DatanodeWrapper datanode;
        private final String state;
        private int replicaIndex;
        @JsonSerialize(using=JsonUtils.ChecksumSerializer.class)
        private final long dataChecksum;

        ReplicaWrapper(ContainerReplicaInfo replica) {
            this.datanode = new DatanodeWrapper(replica.getDatanodeDetails());
            this.state = replica.getState();
            if (replica.getReplicaIndex() > 0) {
                this.replicaIndex = replica.getReplicaIndex();
            }
            this.dataChecksum = replica.getDataChecksum();
        }

        public DatanodeWrapper getDatanode() {
            return this.datanode;
        }

        public String getState() {
            return this.state;
        }

        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public int getReplicaIndex() {
            return this.replicaIndex;
        }

        public long getDataChecksum() {
            return this.dataChecksum;
        }
    }
}

