/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventExecutorMetrics;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.IEventInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedThreadPoolWithAffinityExecutor<P, Q>
implements EventExecutor<P> {
    private static final String EVENT_QUEUE = "EventQueue";
    private static final Logger LOG = LoggerFactory.getLogger(FixedThreadPoolWithAffinityExecutor.class);
    private final Map<String, FixedThreadPoolWithAffinityExecutor> executorMap;
    private final String name;
    private final EventHandler<P> eventHandler;
    private final EventPublisher eventPublisher;
    private final List<BlockingQueue<Q>> workQueues;
    private final List<ThreadPoolExecutor> executors;
    private final EventExecutorMetrics metrics;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private long queueWaitThreshold = 60000L;
    private long execWaitThreshold = 120000L;

    public FixedThreadPoolWithAffinityExecutor(String name, EventHandler<P> eventHandler, List<BlockingQueue<Q>> workQueues, EventPublisher eventPublisher, Class<P> clazz, List<ThreadPoolExecutor> executors, Map<String, FixedThreadPoolWithAffinityExecutor> executorMap) {
        this.name = name;
        this.eventHandler = eventHandler;
        this.workQueues = workQueues;
        this.eventPublisher = eventPublisher;
        this.executors = executors;
        this.executorMap = executorMap;
        this.metrics = new EventExecutorMetrics(EVENT_QUEUE + name, "Event Executor metrics");
        executorMap.put(clazz.getName(), this);
        int i = 0;
        for (BlockingQueue<Q> queue : workQueues) {
            ThreadPoolExecutor threadPoolExecutor = executors.get(i);
            if (threadPoolExecutor.getActiveCount() == 0) {
                threadPoolExecutor.submit(new ContainerReportProcessTask<Q>(queue, this.isRunning, executorMap));
            }
            ++i;
        }
    }

    public void setQueueWaitThreshold(long queueWaitThreshold) {
        this.queueWaitThreshold = queueWaitThreshold;
    }

    public void setExecWaitThreshold(long execWaitThreshold) {
        this.execWaitThreshold = execWaitThreshold;
    }

    public static <Q> List<ThreadPoolExecutor> initializeExecutorPool(List<BlockingQueue<Q>> workQueues) {
        return FixedThreadPoolWithAffinityExecutor.initializeExecutorPool("", workQueues);
    }

    public static <Q> List<ThreadPoolExecutor> initializeExecutorPool(String threadNamePrefix, List<BlockingQueue<Q>> workQueues) {
        ArrayList<ThreadPoolExecutor> executors = new ArrayList<ThreadPoolExecutor>();
        for (int i = 0; i < workQueues.size(); ++i) {
            LinkedBlockingQueue<Runnable> poolQueue = new LinkedBlockingQueue<Runnable>(1);
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(threadNamePrefix + "FixedThreadPoolWithAffinityExecutor-" + i + "-%d").build();
            executors.add(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, poolQueue, threadFactory));
        }
        return executors;
    }

    @Override
    public void onMessage(EventHandler<P> handler, P message, EventPublisher publisher) {
        this.metrics.incrementQueued();
        int index = message.hashCode() & this.workQueues.size() - 1;
        BlockingQueue<Q> queue = this.workQueues.get(index);
        queue.add(message);
        if (queue instanceof IQueueMetrics) {
            this.metrics.incrementDropped(((IQueueMetrics)((Object)queue)).getAndResetDropCount(message.getClass().getSimpleName()));
        }
    }

    @Override
    public long failedEvents() {
        return this.metrics.getFailed();
    }

    @Override
    public long successfulEvents() {
        return this.metrics.getDone();
    }

    @Override
    public long queuedEvents() {
        return this.metrics.getQueued();
    }

    @Override
    public long scheduledEvents() {
        return this.metrics.getScheduled();
    }

    @Override
    public long droppedEvents() {
        return this.metrics.getDropped();
    }

    @Override
    public long longWaitInQueueEvents() {
        return this.metrics.getLongWaitInQueue();
    }

    @Override
    public long longTimeExecutionEvents() {
        return this.metrics.getLongExecution();
    }

    @Override
    public void close() {
        this.isRunning.set(false);
        for (ThreadPoolExecutor executor : this.executors) {
            executor.shutdown();
        }
        this.executorMap.clear();
        this.metrics.unregister();
        DefaultMetricsSystem.instance().unregisterSource(EVENT_QUEUE + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class ContainerReportProcessTask<P>
    implements Runnable {
        private BlockingQueue<P> queue;
        private AtomicBoolean isRunning;
        private Map<String, FixedThreadPoolWithAffinityExecutor> executorMap;

        public ContainerReportProcessTask(BlockingQueue<P> queue, AtomicBoolean isRunning, Map<String, FixedThreadPoolWithAffinityExecutor> executorMap) {
            this.queue = queue;
            this.isRunning = isRunning;
            this.executorMap = executorMap;
        }

        @Override
        public void run() {
            while (this.isRunning.get()) {
                try {
                    P report = this.queue.poll(1L, TimeUnit.MILLISECONDS);
                    if (report == null) continue;
                    FixedThreadPoolWithAffinityExecutor executor = this.executorMap.get(report.getClass().getName());
                    if (null == executor) {
                        LOG.warn("Executor for report is not found");
                        continue;
                    }
                    long createTime = 0L;
                    String eventId = "";
                    if (report instanceof IEventInfo) {
                        createTime = ((IEventInfo)report).getCreateTime();
                        eventId = ((IEventInfo)report).getEventId();
                    }
                    long curTime = Time.monotonicNow();
                    if (createTime != 0L && curTime - createTime > executor.queueWaitThreshold) {
                        executor.metrics.incrementLongWaitInQueue();
                        LOG.warn("Event remained in queue for long time {} millisec, {}", (Object)(curTime - createTime), (Object)eventId);
                    }
                    executor.metrics.incrementScheduled();
                    try {
                        executor.eventHandler.onMessage(report, executor.eventPublisher);
                        executor.metrics.incrementDone();
                        curTime = Time.monotonicNow();
                        if (createTime != 0L && curTime - createTime > executor.execWaitThreshold) {
                            executor.metrics.incrementLongExecution();
                            LOG.warn("Event taken long execution time {} millisec, {}", (Object)(curTime - createTime), (Object)eventId);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error("Error on execution message {}", report, (Object)ex);
                        executor.metrics.incrementFailed();
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    LOG.warn("Interrupt of execution of Reports");
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupt of execution of Reports");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public static interface IQueueMetrics {
        public int getAndResetDropCount(String var1);
    }
}

