/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.HddsUtils;

public final class Archiver {
    static final int MIN_BUFFER_SIZE = 8192;
    static final int MAX_BUFFER_SIZE = 0x100000;

    private Archiver() {
    }

    public static void create(File tarFile, Path from) throws IOException {
        try (ArchiveOutputStream<TarArchiveEntry> out = Archiver.tar(Files.newOutputStream(tarFile.toPath(), new OpenOption[0]));){
            Archiver.includePath(from, "", out);
        }
    }

    public static void extract(File tarFile, Path dir) throws IOException {
        Files.createDirectories(dir, new FileAttribute[0]);
        String parent = dir.toString();
        try (ArchiveInputStream<TarArchiveEntry> in = Archiver.untar(Files.newInputStream(tarFile.toPath(), new OpenOption[0]));){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)in.getNextEntry()) != null) {
                Path path = Paths.get(parent, entry.getName());
                Archiver.extractEntry((ArchiveEntry)entry, in, entry.getSize(), dir, path);
            }
        }
    }

    public static byte[] readEntry(InputStream input, long size) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)output, (int)Archiver.getBufferSize(size));
        return output.toByteArray();
    }

    public static void includePath(Path dir, String subdir, ArchiveOutputStream<TarArchiveEntry> archiveOutput) throws IOException {
        TarArchiveEntry entry = (TarArchiveEntry)archiveOutput.createArchiveEntry(dir.toFile(), subdir);
        archiveOutput.putArchiveEntry((ArchiveEntry)entry);
        archiveOutput.closeArchiveEntry();
        try (Stream<Path> dirEntries = Files.list(dir);){
            for (Path path : dirEntries.collect(Collectors.toList())) {
                File file = path.toFile();
                String entryName = subdir + "/" + path.getFileName();
                if (file.isDirectory()) {
                    Archiver.includePath(path, entryName, archiveOutput);
                    continue;
                }
                Archiver.includeFile(file, entryName, archiveOutput);
            }
        }
    }

    public static long includeFile(File file, String entryName, ArchiveOutputStream<TarArchiveEntry> archiveOutput) throws IOException {
        long bytes;
        TarArchiveEntry entry = (TarArchiveEntry)archiveOutput.createArchiveEntry(file, entryName);
        archiveOutput.putArchiveEntry((ArchiveEntry)entry);
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            bytes = IOUtils.copy((InputStream)input, archiveOutput, (int)Archiver.getBufferSize(file.length()));
        }
        archiveOutput.closeArchiveEntry();
        return bytes;
    }

    public static void extractEntry(ArchiveEntry entry, InputStream input, long size, Path ancestor, Path path) throws IOException {
        HddsUtils.validatePath((Path)path, (Path)ancestor);
        if (entry.isDirectory()) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Path parent = path.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStream fileOutput = Files.newOutputStream(path, new OpenOption[0]);
                 BufferedOutputStream output = new BufferedOutputStream(fileOutput);){
                IOUtils.copy((InputStream)input, (OutputStream)output, (int)Archiver.getBufferSize(size));
            }
        }
    }

    public static ArchiveInputStream<TarArchiveEntry> untar(InputStream input) {
        return new TarArchiveInputStream(input);
    }

    public static ArchiveOutputStream<TarArchiveEntry> tar(OutputStream output) {
        TarArchiveOutputStream os = new TarArchiveOutputStream(output);
        os.setBigNumberMode(2);
        os.setLongFileMode(3);
        return os;
    }

    static int getBufferSize(long fileSize) {
        return Math.toIntExact(Math.min(0x100000L, Math.max(fileSize, 8192L)));
    }
}

