/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBUpdatesWrapper;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.SequenceNumberNotFoundException;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TypedTable;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.hdds.utils.db.managed.ManagedCompactRangeOptions;
import org.apache.ozone.rocksdiff.RocksDBCheckpointDiffer;
import org.apache.ratis.util.UncheckedAutoCloseable;

@InterfaceStability.Evolving
public interface DBStore
extends UncheckedAutoCloseable,
BatchOperationHandler {
    public Table<byte[], byte[]> getTable(String var1) throws RocksDatabaseException;

    default public <KEY, VALUE> TypedTable<KEY, VALUE> getTable(String name, Codec<KEY> keyCodec, Codec<VALUE> valueCodec) throws RocksDatabaseException, CodecException {
        return this.getTable(name, keyCodec, valueCodec, TableCache.CacheType.PARTIAL_CACHE);
    }

    public <KEY, VALUE> TypedTable<KEY, VALUE> getTable(String var1, Codec<KEY> var2, Codec<VALUE> var3, TableCache.CacheType var4) throws RocksDatabaseException, CodecException;

    public List<Table<?, ?>> listTables();

    public void flushDB() throws RocksDatabaseException;

    public void flushLog(boolean var1) throws RocksDatabaseException;

    public RocksDBCheckpointDiffer getRocksDBCheckpointDiffer();

    public void compactDB() throws RocksDatabaseException;

    public void compactTable(String var1) throws RocksDatabaseException;

    public void compactTable(String var1, ManagedCompactRangeOptions var2) throws RocksDatabaseException;

    public long getEstimatedKeyCount() throws RocksDatabaseException;

    public DBCheckpoint getCheckpoint(boolean var1) throws RocksDatabaseException;

    public DBCheckpoint getCheckpoint(String var1, boolean var2) throws RocksDatabaseException;

    public File getDbLocation();

    public Map<Integer, String> getTableNames();

    public DBUpdatesWrapper getUpdatesSince(long var1) throws SequenceNumberNotFoundException;

    public DBUpdatesWrapper getUpdatesSince(long var1, long var3) throws SequenceNumberNotFoundException;

    public boolean isClosed();
}

