/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.Closeable;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.Table;

public interface TableIterator<KEY, T>
extends Iterator<T>,
Closeable {
    @Override
    public void close() throws RocksDatabaseException;

    public void seekToFirst();

    public void seekToLast();

    public T seek(KEY var1) throws RocksDatabaseException, CodecException;

    public void removeFromDB() throws RocksDatabaseException, CodecException;

    public static <K, INPUT, OUTPUT> TableIterator<K, OUTPUT> convert(final Table.KeyValueIterator<K, INPUT> i, final Function<Table.KeyValue<K, INPUT>, OUTPUT> converter) throws RocksDatabaseException, CodecException {
        return new TableIterator<K, OUTPUT>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public OUTPUT next() {
                return converter.apply((Table.KeyValue)i.next());
            }

            @Override
            public void close() throws RocksDatabaseException {
                i.close();
            }

            @Override
            public void seekToFirst() {
                i.seekToFirst();
            }

            @Override
            public void seekToLast() {
                i.seekToLast();
            }

            @Override
            public OUTPUT seek(K key) throws RocksDatabaseException, CodecException {
                return converter.apply((Table.KeyValue)i.seek(key));
            }

            @Override
            public void removeFromDB() throws RocksDatabaseException, CodecException {
                i.removeFromDB();
            }
        };
    }
}

