/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.logging.log4j.message.Message;
import org.apache.ratis.util.MemoizedSupplier;

public final class AuditMessage
implements Message {
    private static final long serialVersionUID = 1L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final transient Supplier<String> messageSupplier;
    private final String op;
    private final Throwable throwable;

    private AuditMessage(String user, String ip, String op, Map<String, String> params, String ret, Throwable throwable, AuditLogger.PerformanceStringBuilder performance) {
        this.op = op;
        this.messageSupplier = MemoizedSupplier.valueOf(() -> this.formMessage(user, ip, op, params, ret, performance));
        this.throwable = throwable;
    }

    public String getFormattedMessage() {
        return this.messageSupplier.get();
    }

    public String getFormat() {
        return null;
    }

    public Object[] getParameters() {
        return new Object[0];
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getOp() {
        return this.op;
    }

    private String formMessage(String userStr, String ipStr, String opStr, Map<String, String> paramsMap, String retStr, AuditLogger.PerformanceStringBuilder performanceMap) {
        String perf = performanceMap != null ? " | perf=" + performanceMap.build() : "";
        String params = this.formatParamsAsJson(paramsMap);
        return "user=" + userStr + " | ip=" + ipStr + " | op=" + opStr + " " + params + " | ret=" + retStr + perf;
    }

    private String formatParamsAsJson(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.isEmpty()) {
            return "{}";
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(paramsMap);
        }
        catch (Exception e) {
            return paramsMap.toString();
        }
    }

    public static class Builder {
        private Throwable throwable;
        private String user;
        private String ip;
        private String op;
        private Map<String, String> params;
        private String ret;
        private AuditLogger.PerformanceStringBuilder performance;

        public Builder setUser(String usr) {
            this.user = usr;
            return this;
        }

        public Builder atIp(String ipAddr) {
            this.ip = ipAddr;
            return this;
        }

        public Builder forOperation(AuditAction action) {
            this.op = action.getAction();
            return this;
        }

        public Builder withParams(Map<String, String> args) {
            this.params = args;
            return this;
        }

        public Builder withResult(AuditEventStatus result) {
            this.ret = result.getStatus();
            return this;
        }

        public Builder withException(Throwable ex) {
            this.throwable = ex;
            return this;
        }

        public Builder setPerformance(AuditLogger.PerformanceStringBuilder perf) {
            this.performance = perf;
            return this;
        }

        public AuditMessage build() {
            return new AuditMessage(this.user, this.ip, this.op, this.params, this.ret, this.throwable, this.performance);
        }
    }
}

