/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.shell.s3;

import java.io.IOException;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.shell.OzoneAddress;
import org.apache.hadoop.ozone.shell.s3.S3Handler;
import org.apache.hadoop.security.UserGroupInformation;
import picocli.CommandLine;

@CommandLine.Command(name="setsecret", aliases={"set-secret"}, description={"Set s3 secret for current user"})
public class SetS3SecretHandler
extends S3Handler {
    @CommandLine.Option(names={"-u"}, description={"Specify the user to perform the operation on (Admins only)'"})
    private String username;
    @CommandLine.Option(names={"-s", "--secret", "--secretKey"}, description={"Secret key"}, required=true)
    private String secretKey;
    @CommandLine.Option(names={"-e"}, description={"Print out variables together with 'export' prefix, to use it from 'eval $(ozone s3 setsecret)'"})
    private boolean export;

    @Override
    protected boolean isApplicable() {
        return this.securityEnabled();
    }

    @Override
    protected void execute(OzoneClient client, OzoneAddress address) throws IOException {
        if (this.username == null || this.username.isEmpty()) {
            this.username = UserGroupInformation.getCurrentUser().getUserName();
        }
        S3SecretValue accessIdSecretKeyPair = client.getObjectStore().setS3Secret(this.username, this.secretKey);
        if (this.export) {
            this.out().println("export AWS_ACCESS_KEY_ID='" + accessIdSecretKeyPair.getAwsAccessKey() + "'");
            this.out().println("export AWS_SECRET_ACCESS_KEY='" + accessIdSecretKeyPair.getAwsSecret() + "'");
        } else {
            this.out().println(accessIdSecretKeyPair);
        }
    }
}

