/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeQueueMetrics;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.ClosePipelineCommandHandler;
import org.apache.hadoop.ozone.container.common.states.DatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.InitDatanodeState;
import org.apache.hadoop.ozone.container.common.states.datanode.RunningDatanodeState;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlockCommandStatus;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateContext {
    @VisibleForTesting
    static final String CONTAINER_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String NODE_REPORT_PROTO_NAME = StorageContainerDatanodeProtocolProtos.NodeReportProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String PIPELINE_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.PipelineReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String COMMAND_STATUS_REPORTS_PROTO_NAME = StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.getDescriptor().getFullName();
    @VisibleForTesting
    static final String INCREMENTAL_CONTAINER_REPORT_PROTO_NAME = StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto.getDescriptor().getFullName();
    static final Logger LOG = LoggerFactory.getLogger(StateContext.class);
    private final Queue<SCMCommand<?>> commandQueue;
    private final Map<Long, CommandStatus> cmdStatusMap;
    private final Lock lock;
    private final DatanodeStateMachine parentDatanodeStateMachine;
    private final AtomicLong stateExecutionCount;
    private final ConfigurationSource conf;
    private final Set<InetSocketAddress> endpoints;
    private final AtomicReference<Message> containerReports;
    private final AtomicReference<Message> nodeReport;
    private final AtomicReference<Message> pipelineReports;
    private final Map<InetSocketAddress, List<Message>> incrementalReportsQueue;
    private final Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> containerActions;
    private final Map<InetSocketAddress, PipelineActionMap> pipelineActions;
    private DatanodeStateMachine.DatanodeStates state;
    private boolean shutdownOnError = false;
    private boolean shutdownGracefully = false;
    private final AtomicLong threadPoolNotAvailableCount;
    private final AtomicLong lastHeartbeatSent;
    private final Map<InetSocketAddress, Map<String, AtomicBoolean>> isFullReportReadyToBeSent;
    private final List<String> fullReportTypeList;
    private final Map<String, AtomicReference<Message>> type2Reports;
    private OptionalLong termOfLeaderSCM = OptionalLong.empty();
    private final AtomicLong heartbeatFrequency;
    private final AtomicLong reconHeartbeatFrequency;
    private final int maxCommandQueueLimit;
    private final String threadNamePrefix;
    private RunningDatanodeState runningDatanodeState;

    public StateContext(ConfigurationSource conf, DatanodeStateMachine.DatanodeStates state, DatanodeStateMachine parent, String threadNamePrefix) {
        this.conf = conf;
        DatanodeConfiguration dnConf = (DatanodeConfiguration)((Object)conf.getObject(DatanodeConfiguration.class));
        this.maxCommandQueueLimit = dnConf.getCommandQueueLimit();
        this.state = state;
        this.parentDatanodeStateMachine = parent;
        this.commandQueue = new LinkedList();
        this.cmdStatusMap = new ConcurrentHashMap<Long, CommandStatus>();
        this.incrementalReportsQueue = new HashMap<InetSocketAddress, List<Message>>();
        this.containerReports = new AtomicReference();
        this.nodeReport = new AtomicReference();
        this.pipelineReports = new AtomicReference();
        this.endpoints = new HashSet<InetSocketAddress>();
        this.containerActions = new HashMap<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>>();
        this.pipelineActions = new ConcurrentHashMap<InetSocketAddress, PipelineActionMap>();
        this.lock = new ReentrantLock();
        this.stateExecutionCount = new AtomicLong(0L);
        this.threadPoolNotAvailableCount = new AtomicLong(0L);
        this.lastHeartbeatSent = new AtomicLong(0L);
        this.isFullReportReadyToBeSent = new HashMap<InetSocketAddress, Map<String, AtomicBoolean>>();
        this.fullReportTypeList = new ArrayList<String>();
        this.type2Reports = new HashMap<String, AtomicReference<Message>>();
        this.threadNamePrefix = threadNamePrefix;
        this.heartbeatFrequency = new AtomicLong(HddsServerUtil.getScmInitialHeartbeatInterval((ConfigurationSource)conf));
        this.reconHeartbeatFrequency = new AtomicLong(HddsServerUtil.getInitialReconHeartbeatInterval((ConfigurationSource)conf));
        this.initReportTypeCollection();
    }

    private void initReportTypeCollection() {
        this.fullReportTypeList.add(CONTAINER_REPORTS_PROTO_NAME);
        this.type2Reports.put(CONTAINER_REPORTS_PROTO_NAME, this.containerReports);
        this.fullReportTypeList.add(NODE_REPORT_PROTO_NAME);
        this.type2Reports.put(NODE_REPORT_PROTO_NAME, this.nodeReport);
        this.fullReportTypeList.add(PIPELINE_REPORTS_PROTO_NAME);
        this.type2Reports.put(PIPELINE_REPORTS_PROTO_NAME, this.pipelineReports);
    }

    public DatanodeStateMachine getParent() {
        return this.parentDatanodeStateMachine;
    }

    boolean isEntering() {
        return this.stateExecutionCount.get() == 0L;
    }

    boolean isExiting(DatanodeStateMachine.DatanodeStates newState) {
        boolean isExiting;
        boolean bl = isExiting = this.state != newState && this.stateExecutionCount.get() > 0L;
        if (isExiting) {
            this.stateExecutionCount.set(0L);
        }
        return isExiting;
    }

    public DatanodeStateMachine.DatanodeStates getState() {
        return this.state;
    }

    public void setState(DatanodeStateMachine.DatanodeStates state) {
        if (this.state != state) {
            if (this.state.isTransitionAllowedTo(state)) {
                this.state = state;
            } else {
                LOG.warn("Ignore disallowed transition from {} to {}", (Object)this.state, (Object)state);
            }
        }
    }

    private void setShutdownOnError() {
        this.shutdownOnError = true;
    }

    void setShutdownGracefully() {
        this.shutdownGracefully = true;
    }

    public boolean getShutdownOnError() {
        return this.shutdownOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncrementalReport(Message report) {
        if (report == null) {
            return;
        }
        Descriptors.Descriptor descriptor = report.getDescriptorForType();
        Preconditions.checkState((descriptor != null ? 1 : 0) != 0);
        String reportType = descriptor.getFullName();
        Preconditions.checkState((reportType != null ? 1 : 0) != 0);
        Map<InetSocketAddress, List<Message>> map = this.incrementalReportsQueue;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                this.incrementalReportsQueue.get(endpoint).add(report);
            }
        }
    }

    public void refreshFullReport(Message report) {
        if (report == null) {
            return;
        }
        Descriptors.Descriptor descriptor = report.getDescriptorForType();
        Preconditions.checkState((descriptor != null ? 1 : 0) != 0);
        String reportType = descriptor.getFullName();
        Preconditions.checkState((reportType != null ? 1 : 0) != 0);
        if (!this.fullReportTypeList.contains(reportType)) {
            throw new IllegalArgumentException("not full report message type: " + reportType);
        }
        this.type2Reports.get(reportType).set(report);
        if (this.isFullReportReadyToBeSent != null) {
            for (Map<String, AtomicBoolean> mp : this.isFullReportReadyToBeSent.values()) {
                mp.get(reportType).set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBackReports(List<Message> reportsToPutBack, InetSocketAddress endpoint) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("endpoint: {}, size of reportsToPutBack: {}", (Object)endpoint, (Object)reportsToPutBack.size());
        }
        for (Message report : reportsToPutBack) {
            Descriptors.Descriptor descriptor = report.getDescriptorForType();
            Preconditions.checkState((descriptor != null ? 1 : 0) != 0);
            String reportType = descriptor.getFullName();
            Preconditions.checkState((reportType != null ? 1 : 0) != 0);
        }
        Map<InetSocketAddress, List<Message>> map = this.incrementalReportsQueue;
        synchronized (map) {
            if (this.incrementalReportsQueue.containsKey(endpoint)) {
                this.incrementalReportsQueue.get(endpoint).addAll(0, reportsToPutBack);
            }
        }
    }

    public List<Message> getAllAvailableReports(InetSocketAddress endpoint) {
        int maxLimit = Integer.MAX_VALUE;
        return this.getAllAvailableReportsUpToLimit(endpoint, maxLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageContainerDatanodeProtocolProtos.ContainerReportsProto getFullContainerReportDiscardPendingICR() throws IOException {
        OzoneContainer ozoneContainer = this.parentDatanodeStateMachine.getContainer();
        synchronized (ozoneContainer) {
            Map<InetSocketAddress, List<Message>> map = this.incrementalReportsQueue;
            synchronized (map) {
                for (Map.Entry<InetSocketAddress, List<Message>> entry : this.incrementalReportsQueue.entrySet()) {
                    if (entry.getValue() == null) continue;
                    entry.getValue().removeIf(generatedMessage -> generatedMessage instanceof StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto);
                }
            }
            return this.parentDatanodeStateMachine.getContainer().getContainerSet().getContainerReport();
        }
    }

    @VisibleForTesting
    List<Message> getAllAvailableReportsUpToLimit(InetSocketAddress endpoint, int limit) {
        List<Message> reports = this.getFullReports(endpoint, limit);
        List<Message> incrementalReports = this.getIncrementalReports(endpoint, limit - reports.size());
        reports.addAll(incrementalReports);
        return reports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Message> getIncrementalReports(InetSocketAddress endpoint, int maxLimit) {
        LinkedList<Message> reportsToReturn = new LinkedList<Message>();
        Map<InetSocketAddress, List<Message>> map = this.incrementalReportsQueue;
        synchronized (map) {
            List<Message> reportsForEndpoint = this.incrementalReportsQueue.get(endpoint);
            if (reportsForEndpoint != null) {
                List<Message> tempList = reportsForEndpoint.subList(0, Math.min(reportsForEndpoint.size(), maxLimit));
                reportsToReturn.addAll(tempList);
                tempList.clear();
            }
        }
        return reportsToReturn;
    }

    List<Message> getFullReports(InetSocketAddress endpoint, int maxLimit) {
        int count = 0;
        Map<String, AtomicBoolean> mp = this.isFullReportReadyToBeSent.get(endpoint);
        LinkedList<Message> fullReports = new LinkedList<Message>();
        if (null != mp) {
            for (Map.Entry<String, AtomicBoolean> kv : mp.entrySet()) {
                if (count == maxLimit) break;
                if (!kv.getValue().get()) continue;
                String reportType = kv.getKey();
                AtomicReference<Message> ref = this.type2Reports.get(reportType);
                if (ref == null) {
                    throw new RuntimeException(reportType + " is not a valid full report type!");
                }
                Message msg = ref.get();
                if (msg == null) continue;
                fullReports.add(msg);
                mp.get(reportType).set(false);
                ++count;
            }
        }
        return fullReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerAction(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerActionIfAbsent(StorageContainerDatanodeProtocolProtos.ContainerAction containerAction) {
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            for (InetSocketAddress endpoint : this.endpoints) {
                if (this.containerActions.get(endpoint).contains(containerAction)) continue;
                this.containerActions.get(endpoint).add(containerAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StorageContainerDatanodeProtocolProtos.ContainerAction> getPendingContainerAction(InetSocketAddress endpoint, int maxLimit) {
        ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction> containerActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.ContainerAction>();
        Map<InetSocketAddress, Queue<StorageContainerDatanodeProtocolProtos.ContainerAction>> map = this.containerActions;
        synchronized (map) {
            if (!this.containerActions.isEmpty() && CollectionUtils.isNotEmpty((Collection)this.containerActions.get(endpoint))) {
                Queue<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.containerActions.get(endpoint);
                int size = actions.size();
                int limit = size > maxLimit ? maxLimit : size;
                for (int count = 0; count < limit; ++count) {
                    StorageContainerDatanodeProtocolProtos.ContainerAction action = actions.poll();
                    Preconditions.checkNotNull((Object)action);
                    containerActionList.add(action);
                }
            }
            return containerActionList;
        }
    }

    public boolean addPipelineActionIfAbsent(StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction) {
        PipelineKey key = new PipelineKey(pipelineAction);
        boolean added = false;
        for (InetSocketAddress endpoint : this.endpoints) {
            added = this.pipelineActions.get(endpoint).putIfAbsent(key, pipelineAction) || added;
        }
        return added;
    }

    public List<StorageContainerDatanodeProtocolProtos.PipelineAction> getPendingPipelineAction(InetSocketAddress endpoint, int maxLimit) {
        PipelineActionMap map = this.pipelineActions.get(endpoint);
        if (map == null) {
            return Collections.emptyList();
        }
        OzoneContainer ozoneContainer = this.parentDatanodeStateMachine.getContainer();
        if (ozoneContainer == null) {
            return Collections.emptyList();
        }
        StorageContainerDatanodeProtocolProtos.PipelineReportsProto reports = ozoneContainer.getPipelineReport();
        return map.getActions(reports.getPipelineReportList(), maxLimit);
    }

    public DatanodeState<DatanodeStateMachine.DatanodeStates> getTask() {
        switch (this.state) {
            case INIT: {
                return new InitDatanodeState(this.conf, this.parentDatanodeStateMachine.getConnectionManager(), this);
            }
            case RUNNING: {
                if (this.runningDatanodeState == null) {
                    this.runningDatanodeState = new RunningDatanodeState(this.conf, this.parentDatanodeStateMachine.getConnectionManager(), this);
                }
                return this.runningDatanodeState;
            }
            case SHUTDOWN: {
                return null;
            }
        }
        throw new IllegalArgumentException("Not Implemented yet.");
    }

    @VisibleForTesting
    public boolean isThreadPoolAvailable(ExecutorService executor) {
        if (!(executor instanceof ThreadPoolExecutor)) {
            return true;
        }
        ThreadPoolExecutor ex = (ThreadPoolExecutor)executor;
        return ex.getQueue().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutorService service, long time, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.stateExecutionCount.incrementAndGet();
        DatanodeState<DatanodeStateMachine.DatanodeStates> task = this.getTask();
        if (task == null) {
            return;
        }
        try {
            if (this.isEntering()) {
                task.onEnter();
            }
            if (!this.isThreadPoolAvailable(service)) {
                long count = this.threadPoolNotAvailableCount.incrementAndGet();
                long unavailableTime = Time.monotonicNow() - this.lastHeartbeatSent.get();
                if (unavailableTime > time && count % (long)HddsServerUtil.getLogWarnInterval((ConfigurationSource)this.conf) == 0L) {
                    LOG.warn("No available thread in pool for the past {} seconds and {} times.", (Object)unit.toSeconds(unavailableTime), (Object)count);
                }
                return;
            }
            this.threadPoolNotAvailableCount.set(0L);
            task.execute(service);
            this.lastHeartbeatSent.set(Time.monotonicNow());
            DatanodeStateMachine.DatanodeStates newState = task.await(time, unit);
            if (this.state != newState) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Task {} executed, state transited from {} to {}", new Object[]{task.getClass().getSimpleName(), this.state, newState});
                }
                if (this.isExiting(newState)) {
                    task.onExit();
                }
                this.setState(newState);
            }
            if (!this.shutdownGracefully && this.state == DatanodeStateMachine.DatanodeStates.SHUTDOWN) {
                LOG.error("Critical error occurred in StateMachine, setting shutDownMachine");
                this.setShutdownOnError();
            }
        }
        finally {
            task.clear();
        }
    }

    private void initTermOfLeaderSCM() {
        if (this.termOfLeaderSCM.isPresent()) {
            return;
        }
        AtomicInteger scmNum = new AtomicInteger(0);
        AtomicInteger activeScmNum = new AtomicInteger(0);
        this.getParent().getConnectionManager().getValues().forEach(endpoint -> {
            if (endpoint.isPassive()) {
                return;
            }
            scmNum.incrementAndGet();
            if (endpoint.getState() == EndpointStateMachine.EndPointStates.HEARTBEAT) {
                activeScmNum.incrementAndGet();
            }
        });
        if (activeScmNum.get() < scmNum.get() / 2 + 1) {
            return;
        }
        this.termOfLeaderSCM = this.commandQueue.stream().mapToLong(SCMCommand::getTerm).max();
    }

    private void updateTermOfLeaderSCM(SCMCommand<?> command) {
        this.updateTermOfLeaderSCM(command.getTerm());
    }

    public void updateTermOfLeaderSCM(long newTerm) {
        if (!this.termOfLeaderSCM.isPresent()) {
            return;
        }
        long currentTerm = this.termOfLeaderSCM.getAsLong();
        if (currentTerm < newTerm) {
            this.setTermOfLeaderSCM(newTerm);
        }
    }

    @VisibleForTesting
    public void setTermOfLeaderSCM(long term) {
        this.termOfLeaderSCM = OptionalLong.of(term);
    }

    public OptionalLong getTermOfLeaderSCM() {
        return this.termOfLeaderSCM;
    }

    public SCMCommand<?> getNextCommand() {
        this.lock.lock();
        try {
            this.initTermOfLeaderSCM();
            if (!this.termOfLeaderSCM.isPresent()) {
                SCMCommand<?> sCMCommand = null;
                return sCMCommand;
            }
            while (true) {
                SCMCommand<?> command;
                if ((command = this.commandQueue.poll()) == null) {
                    SCMCommand<?> sCMCommand = null;
                    return sCMCommand;
                }
                this.updateTermOfLeaderSCM(command);
                long currentTerm = this.termOfLeaderSCM.getAsLong();
                if (command.getTerm() == currentTerm) {
                    SCMCommand<?> sCMCommand = command;
                    return sCMCommand;
                }
                LOG.warn("Detect and drop a SCMCommand {} from stale leader SCM, stale term {}, latest term {}.", new Object[]{command, command.getTerm(), currentTerm});
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addCommand(SCMCommand<?> command) {
        this.lock.lock();
        try {
            if (this.commandQueue.size() >= this.maxCommandQueueLimit) {
                LOG.warn("Ignore command as command queue crosses max limit {}.", (Object)this.maxCommandQueueLimit);
                return;
            }
            this.updateTermOfLeaderSCM(command);
            this.commandQueue.add(command);
        }
        finally {
            this.lock.unlock();
        }
        this.addCmdStatus(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getCommandQueueSummary() {
        HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> summary = new HashMap<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer>();
        this.lock.lock();
        try {
            for (SCMCommand sCMCommand : this.commandQueue) {
                summary.put(sCMCommand.getType(), summary.getOrDefault(sCMCommand.getType(), 0) + 1);
            }
        }
        finally {
            this.lock.unlock();
        }
        return summary;
    }

    public boolean isPipelineCloseInProgress(UUID pipelineID) {
        ClosePipelineCommandHandler handler = this.parentDatanodeStateMachine.getCommandDispatcher().getClosePipelineCommandHandler();
        return handler.isPipelineCloseInProgress(pipelineID);
    }

    public long getExecutionCount() {
        return this.stateExecutionCount.get();
    }

    public CommandStatus getCmdStatus(Long key) {
        return this.cmdStatusMap.get(key);
    }

    public void addCmdStatus(Long key, CommandStatus status) {
        this.cmdStatusMap.put(key, status);
    }

    public void addCmdStatus(SCMCommand<?> cmd) {
        if (cmd.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) {
            this.addCmdStatus(cmd.getId(), DeleteBlockCommandStatus.DeleteBlockCommandStatusBuilder.newBuilder().setCmdId(cmd.getId()).setStatus(StorageContainerDatanodeProtocolProtos.CommandStatus.Status.PENDING).setType(cmd.getType()).build());
        }
    }

    public Map<Long, CommandStatus> getCommandStatusMap() {
        return this.cmdStatusMap;
    }

    public boolean updateCommandStatus(Long cmdId, Consumer<CommandStatus> cmdStatusUpdater) {
        CommandStatus updatedCommandStatus = this.cmdStatusMap.computeIfPresent(cmdId, (key, value) -> {
            cmdStatusUpdater.accept((CommandStatus)value);
            return value;
        });
        return updatedCommandStatus != null;
    }

    public void configureHeartbeatFrequency() {
        this.heartbeatFrequency.set(HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.conf));
    }

    public long getHeartbeatFrequency() {
        return this.heartbeatFrequency.get();
    }

    public void addEndpoint(InetSocketAddress endpoint) {
        if (!this.endpoints.contains(endpoint)) {
            this.endpoints.add(endpoint);
            this.containerActions.put(endpoint, new LinkedList());
            this.pipelineActions.put(endpoint, new PipelineActionMap());
            this.incrementalReportsQueue.put(endpoint, new LinkedList());
            HashMap mp = new HashMap();
            this.fullReportTypeList.forEach(e -> mp.putIfAbsent(e, new AtomicBoolean(true)));
            this.isFullReportReadyToBeSent.putIfAbsent(endpoint, mp);
            if (this.getQueueMetrics() != null) {
                this.getQueueMetrics().addEndpoint(endpoint);
            }
        }
    }

    @VisibleForTesting
    public Message getContainerReports() {
        return this.containerReports.get();
    }

    @VisibleForTesting
    public Message getNodeReport() {
        return this.nodeReport.get();
    }

    @VisibleForTesting
    public Message getPipelineReports() {
        return this.pipelineReports.get();
    }

    public void configureReconHeartbeatFrequency() {
        this.reconHeartbeatFrequency.set(HddsServerUtil.getReconHeartbeatInterval((ConfigurationSource)this.conf));
    }

    public long getReconHeartbeatFrequency() {
        return this.reconHeartbeatFrequency.get();
    }

    public Map<InetSocketAddress, Integer> getPipelineActionQueueSize() {
        return this.pipelineActions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PipelineActionMap)e.getValue()).size()));
    }

    public Map<InetSocketAddress, Integer> getContainerActionQueueSize() {
        return this.containerActions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Queue)e.getValue()).size()));
    }

    public Map<InetSocketAddress, Integer> getIncrementalReportQueueSize() {
        return this.incrementalReportsQueue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).size()));
    }

    public DatanodeQueueMetrics getQueueMetrics() {
        return this.parentDatanodeStateMachine.getQueueMetrics();
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    static class PipelineKey {
        private final HddsProtos.PipelineID pipelineID;
        private final StorageContainerDatanodeProtocolProtos.PipelineAction.Action action;

        PipelineKey(StorageContainerDatanodeProtocolProtos.PipelineAction p) {
            this.pipelineID = p.getClosePipeline().getPipelineID();
            this.action = p.getAction();
        }

        boolean equalsId(StorageContainerDatanodeProtocolProtos.PipelineReport report) {
            return this.pipelineID.equals((Object)report.getPipelineID());
        }

        public int hashCode() {
            return Objects.hashCode(this.pipelineID);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PipelineKey)) {
                return false;
            }
            PipelineKey that = (PipelineKey)obj;
            return Objects.equals(this.action, that.action) && Objects.equals(this.pipelineID, that.pipelineID);
        }
    }

    static class PipelineActionMap {
        private final LinkedHashMap<PipelineKey, StorageContainerDatanodeProtocolProtos.PipelineAction> map = new LinkedHashMap();

        PipelineActionMap() {
        }

        synchronized int size() {
            return this.map.size();
        }

        synchronized boolean putIfAbsent(PipelineKey key, StorageContainerDatanodeProtocolProtos.PipelineAction pipelineAction) {
            return this.map.putIfAbsent(key, pipelineAction) == null;
        }

        synchronized List<StorageContainerDatanodeProtocolProtos.PipelineAction> getActions(List<StorageContainerDatanodeProtocolProtos.PipelineReport> reports, int max) {
            if (this.map.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction> pipelineActionList = new ArrayList<StorageContainerDatanodeProtocolProtos.PipelineAction>();
            int limit = Math.min(this.map.size(), max);
            Iterator<Map.Entry<PipelineKey, StorageContainerDatanodeProtocolProtos.PipelineAction>> i = this.map.entrySet().iterator();
            for (int count = 0; count < limit && i.hasNext(); ++count) {
                Map.Entry<PipelineKey, StorageContainerDatanodeProtocolProtos.PipelineAction> entry = i.next();
                StorageContainerDatanodeProtocolProtos.PipelineAction action = entry.getValue();
                if (action.hasClosePipeline()) {
                    if (reports.stream().noneMatch(entry.getKey()::equalsId)) {
                        i.remove();
                        continue;
                    }
                } else {
                    i.remove();
                }
                pipelineActionList.add(action);
            }
            return pipelineActionList;
        }
    }
}

