/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
@Metrics(about="EC Reconstruction Coordinator Metrics", context="ozone")
public final class ECReconstructionMetrics {
    private static final String SOURCE = ECReconstructionMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong blockGroupReconstructionTotal;
    @Metric
    private MutableCounterLong blockGroupReconstructionFailsTotal;
    @Metric
    private MutableCounterLong reconstructionTotal;
    @Metric
    private MutableCounterLong reconstructionFailsTotal;

    private ECReconstructionMetrics() {
    }

    public static ECReconstructionMetrics create() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (ECReconstructionMetrics)ms.register(SOURCE, "EC Reconstruction Coordinator Metrics", (Object)new ECReconstructionMetrics());
    }

    public void unRegister() {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE);
    }

    public void incBlockGroupReconstructionTotal(long count) {
        this.blockGroupReconstructionTotal.incr(count);
    }

    public void incBlockGroupReconstructionFailsTotal(long count) {
        this.blockGroupReconstructionFailsTotal.incr(count);
    }

    public void incReconstructionTotal() {
        this.reconstructionTotal.incr();
    }

    public void incReconstructionFailsTotal() {
        this.reconstructionFailsTotal.incr();
    }

    public long getReconstructionTotal() {
        return this.reconstructionTotal.value();
    }

    public long getBlockGroupReconstructionTotal() {
        return this.blockGroupReconstructionTotal.value();
    }
}

