/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientCreator;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="dbp", aliases={"datanode-block-putter"}, description={"Issues putBlock commands to a Ratis pipeline.  The blocks are associated with a list of fake chunks, which do not really exist."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class DatanodeBlockPutter
extends BaseFreonGenerator
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeBlockPutter.class);
    @CommandLine.Option(names={"-c", "--chunks-per-block"}, description={"Number of chunks to include in each putBlock"}, defaultValue="4")
    private int chunksPerBlock;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the fake chunks (in bytes)"}, defaultValue="1024")
    private int chunkSize;
    @CommandLine.Option(names={"-l", "--pipeline"}, description={"Pipeline to use. By default the first RATIS/THREE pipeline will be used."}, defaultValue="")
    private String pipelineId;
    private XceiverClientSpi client;
    private Timer timer;
    private ContainerProtos.ChecksumData checksumProtobuf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConf = this.createOzoneConfiguration();
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)ozoneConf)) {
            throw new IllegalArgumentException("datanode-block-putter is not supported in secure environment");
        }
        try (StorageContainerLocationProtocol scmLocationClient = this.createStorageContainerLocationClient(ozoneConf);){
            Pipeline pipeline = DatanodeBlockPutter.findPipelineForTest(this.pipelineId, scmLocationClient, LOG);
            try (XceiverClientCreator xceiverClientManager = new XceiverClientCreator((ConfigurationSource)ozoneConf);){
                this.client = xceiverClientManager.acquireClient(pipeline);
                this.timer = this.getMetrics().timer("put-block");
                byte[] data = RandomStringUtils.secure().nextAscii(this.chunkSize).getBytes(StandardCharsets.UTF_8);
                Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, 0x100000);
                this.checksumProtobuf = checksum.computeChecksum(data).getProtoBufMessage();
                this.runTests(this::putBlock);
            }
        }
        finally {
            if (this.client != null) {
                this.client.close();
            }
        }
        return null;
    }

    private void putBlock(long stepNo) throws Exception {
        ContainerProtos.DatanodeBlockID blockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(1L).setLocalID(stepNo).setBlockCommitSequenceId(stepNo).build();
        ContainerProtos.BlockData.Builder blockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockId);
        for (long l = 0L; l < (long)this.chunksPerBlock; ++l) {
            ContainerProtos.ChunkInfo.Builder chunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName(this.getPrefix() + "_chunk_" + stepNo).setOffset(l * (long)this.chunkSize).setLen((long)this.chunkSize).setChecksumData(this.checksumProtobuf);
            blockData.addChunks(chunkInfo);
        }
        ContainerProtos.PutBlockRequestProto.Builder putBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(blockData);
        String id = this.client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(blockId.getContainerID()).setDatanodeUuid(id).setPutBlock(putBlockRequest);
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        this.timer.time(() -> {
            this.client.sendCommand(request);
            return null;
        });
    }
}

