/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.exception;

public final class ExceptionTools {
    private static int maxCauseLookups = 256;

    public static <T extends Throwable> T getCause(Throwable t, Class<? extends T> type) {
        Throwable next = t.getCause();
        for (int i = 0; i < maxCauseLookups; ++i) {
            if (next == null) {
                return null;
            }
            if (type.isInstance(next)) {
                return (T)next;
            }
            Throwable prev = next;
            if (prev != (next = next.getCause())) continue;
            return null;
        }
        return null;
    }

    private ExceptionTools() {
    }
}

