/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneConfigUtil {
    static final Logger LOG = LoggerFactory.getLogger(OzoneConfigUtil.class);

    private OzoneConfigUtil() {
    }

    public static ReplicationConfig resolveReplicationConfigPreference(HddsProtos.ReplicationType clientType, HddsProtos.ReplicationFactor clientFactor, HddsProtos.ECReplicationConfig clientECReplicationConfig, DefaultReplicationConfig bucketDefaultReplicationConfig, OzoneManager ozoneManager) throws OMException {
        ReplicationConfig replicationConfig = null;
        if (clientType != HddsProtos.ReplicationType.NONE) {
            replicationConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)clientType, (HddsProtos.ReplicationFactor)clientFactor, (HddsProtos.ECReplicationConfig)clientECReplicationConfig);
            ozoneManager.validateReplicationConfig(replicationConfig);
        } else {
            replicationConfig = bucketDefaultReplicationConfig != null ? bucketDefaultReplicationConfig.getReplicationConfig() : ozoneManager.getDefaultReplicationConfig();
        }
        return replicationConfig;
    }

    public static long limitValue(long clientConfValue, String clientConfName, String serverConfName, long serverConfValue) {
        long limitVal = clientConfValue;
        if (clientConfValue > serverConfValue) {
            LOG.debug("{} config value is greater than server config {} value currently set at : {}, so limiting the config value to be used at server side to max value supported at server - {}", new Object[]{clientConfName, serverConfName, serverConfValue, serverConfValue});
            limitVal = serverConfValue;
        }
        if (limitVal <= 1L) {
            limitVal = 2L;
        }
        return limitVal;
    }
}

