/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceListJSONServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceListJSONServlet.class);
    private static final long serialVersionUID = 1L;
    private transient OzoneManager om;

    public void init() throws ServletException {
        this.om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            response.setContentType("application/json; charset=utf8");
            try (PrintWriter writer = response.getWriter();){
                writer.write(objectMapper.writeValueAsString(this.om.getServiceList()));
            }
        }
        catch (IOException e) {
            LOG.error("Caught an exception while processing ServiceList request", (Throwable)e);
            response.setStatus(500);
        }
    }
}

