/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.snapshot;

import java.io.IOException;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.ratis.server.protocol.TermIndex;

public final class OMSnapshotMoveUtils {
    private OMSnapshotMoveUtils() {
    }

    public static void updateCache(OzoneManager ozoneManager, SnapshotInfo fromSnapshot, SnapshotInfo toSnapshot, ExecutionContext context) throws IOException {
        OmMetadataManagerImpl omMetadataManager = (OmMetadataManagerImpl)ozoneManager.getMetadataManager();
        fromSnapshot.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
        omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)fromSnapshot.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)fromSnapshot));
        if (toSnapshot != null) {
            toSnapshot.setLastTransactionInfo(TransactionInfo.valueOf((TermIndex)context.getTermIndex()).toByteString());
            omMetadataManager.getSnapshotInfoTable().addCacheEntry(new CacheKey((Object)toSnapshot.getTableKey()), CacheValue.get((long)context.getIndex(), (Object)toSnapshot));
        }
    }
}

