/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.ozone.lock.BootstrapStateHandler;
import org.apache.hadoop.ozone.om.DeletingServiceMetrics;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.ClientId;

public abstract class AbstractKeyDeletingService
extends BackgroundService
implements BootstrapStateHandler {
    private final OzoneManager ozoneManager;
    private final DeletingServiceMetrics metrics;
    private final OMPerformanceMetrics perfMetrics;
    private final ClientId clientId = ClientId.randomId();
    private final AtomicLong runCount;
    private final AtomicLong callId;
    private final AtomicBoolean suspended;
    private final BootstrapStateHandler.Lock lock = new BootstrapStateHandler.Lock();

    public AbstractKeyDeletingService(String serviceName, long interval, TimeUnit unit, int threadPoolSize, long serviceTimeout, OzoneManager ozoneManager) {
        super(serviceName, interval, unit, threadPoolSize, serviceTimeout, ozoneManager.getThreadNamePrefix());
        this.ozoneManager = ozoneManager;
        this.runCount = new AtomicLong(0L);
        this.metrics = ozoneManager.getDeletionMetrics();
        this.perfMetrics = ozoneManager.getPerfMetrics();
        this.callId = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
    }

    protected OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws ServiceException {
        return OzoneManagerRatisUtils.submitRequest(this.ozoneManager, omRequest, this.clientId, this.callId.incrementAndGet());
    }

    final boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return !this.suspended.get() && this.getOzoneManager().isLeaderReady();
    }

    boolean isPreviousPurgeTransactionFlushed() throws IOException {
        TransactionInfo lastAOSTransactionId = this.metrics.getLastAOSTransactionInfo();
        TransactionInfo flushedTransactionId = TransactionInfo.readTransactionInfo((DBStoreHAManager)this.getOzoneManager().getMetadataManager());
        if (flushedTransactionId != null && lastAOSTransactionId.compareTo(flushedTransactionId) > 0) {
            BackgroundService.LOG.info("Skipping AOS processing since changes to deleted space of AOS have not been flushed to disk last Purge Transaction: {}, Flushed Disk Transaction: {}", (Object)lastAOSTransactionId, (Object)flushedTransactionId);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public void suspend() throws ExecutionException, InterruptedException {
        this.suspended.set(true);
        this.getFuture().get();
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    protected boolean isBufferLimitCrossed(int maxLimit, int cLimit, int increment) {
        return cLimit + increment >= maxLimit;
    }

    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    ClientId getClientId() {
        return this.clientId;
    }

    DeletingServiceMetrics getMetrics() {
        return this.metrics;
    }

    OMPerformanceMetrics getPerfMetrics() {
        return this.perfMetrics;
    }

    @VisibleForTesting
    public AtomicLong getRunCount() {
        return this.runCount;
    }

    public AtomicLong getCallId() {
        return this.callId;
    }

    public BootstrapStateHandler.Lock getBootstrapStateLock() {
        return this.lock;
    }

    protected void submitSetSnapshotRequests(List<OzoneManagerProtocolProtos.SetSnapshotPropertyRequest> setSnapshotPropertyRequests) {
        if (setSnapshotPropertyRequests.isEmpty()) {
            return;
        }
        OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).addAllSetSnapshotPropertyRequests(setSnapshotPropertyRequests).setClientId(this.clientId.toString()).build();
        try {
            this.submitRequest(omRequest);
        }
        catch (ServiceException e) {
            BackgroundService.LOG.error("Failed to submit set snapshot property request", (Throwable)e);
        }
    }
}

