/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot.filter;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.lock.FlatResource;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.snapshot.MultiSnapshotLocks;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.ratis.util.function.CheckedFunction;
import org.apache.ratis.util.function.UncheckedAutoCloseableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReclaimableFilter<V>
implements CheckedFunction<Table.KeyValue<String, V>, Boolean, IOException>,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ReclaimableFilter.class);
    private final OzoneManager ozoneManager;
    private final SnapshotInfo currentSnapshotInfo;
    private final OmSnapshotManager omSnapshotManager;
    private final SnapshotChainManager snapshotChainManager;
    private final List<SnapshotInfo> tmpValidationSnapshotInfos;
    private final List<UUID> lockedSnapshotIds;
    private final List<SnapshotInfo> previousSnapshotInfos;
    private final List<UncheckedAutoCloseableSupplier<OmSnapshot>> previousOmSnapshots;
    private final MultiSnapshotLocks snapshotIdLocks;
    private Long volumeId;
    private OmBucketInfo bucketInfo;
    private final KeyManager keyManager;
    private final int numberOfPreviousSnapshotsFromChain;

    public ReclaimableFilter(OzoneManager ozoneManager, OmSnapshotManager omSnapshotManager, SnapshotChainManager snapshotChainManager, SnapshotInfo currentSnapshotInfo, KeyManager keyManager, IOzoneManagerLock lock, int numberOfPreviousSnapshotsFromChain) {
        this.ozoneManager = ozoneManager;
        this.omSnapshotManager = omSnapshotManager;
        this.currentSnapshotInfo = currentSnapshotInfo;
        this.snapshotChainManager = snapshotChainManager;
        this.snapshotIdLocks = new MultiSnapshotLocks(lock, (IOzoneManagerLock.Resource)FlatResource.SNAPSHOT_GC_LOCK, false);
        this.keyManager = keyManager;
        this.numberOfPreviousSnapshotsFromChain = numberOfPreviousSnapshotsFromChain;
        this.previousOmSnapshots = new ArrayList<UncheckedAutoCloseableSupplier<OmSnapshot>>(numberOfPreviousSnapshotsFromChain);
        this.previousSnapshotInfos = new ArrayList<SnapshotInfo>(numberOfPreviousSnapshotsFromChain);
        this.tmpValidationSnapshotInfos = new ArrayList<SnapshotInfo>(numberOfPreviousSnapshotsFromChain);
        this.lockedSnapshotIds = new ArrayList<UUID>(numberOfPreviousSnapshotsFromChain + 1);
    }

    private List<SnapshotInfo> getLastNSnapshotInChain(String volume, String bucket) throws IOException {
        if (!(this.currentSnapshotInfo == null || this.currentSnapshotInfo.getVolumeName().equals(volume) && this.currentSnapshotInfo.getBucketName().equals(bucket))) {
            throw new IOException("Volume and Bucket name for snapshot : " + this.currentSnapshotInfo + " do not match " + "against the volume: " + volume + " and bucket: " + bucket + " of the key.");
        }
        this.tmpValidationSnapshotInfos.clear();
        SnapshotInfo snapshotInfo = this.currentSnapshotInfo == null ? SnapshotUtils.getLatestSnapshotInfo(volume, bucket, this.ozoneManager, this.snapshotChainManager) : SnapshotUtils.getPreviousSnapshot(this.ozoneManager, this.snapshotChainManager, this.currentSnapshotInfo);
        while (this.tmpValidationSnapshotInfos.size() < this.numberOfPreviousSnapshotsFromChain) {
            if (!OmSnapshotManager.areSnapshotChangesFlushedToDB(this.ozoneManager.getMetadataManager(), snapshotInfo)) {
                throw new IOException("Changes made to the snapshot: " + snapshotInfo + " have not been flushed to the disk.");
            }
            this.tmpValidationSnapshotInfos.add(snapshotInfo);
            SnapshotInfo snapshotInfo2 = snapshotInfo = snapshotInfo == null ? null : SnapshotUtils.getPreviousSnapshot(this.ozoneManager, this.snapshotChainManager, snapshotInfo);
        }
        Collections.reverse(this.tmpValidationSnapshotInfos);
        return this.tmpValidationSnapshotInfos;
    }

    private boolean validateExistingLastNSnapshotsInChain(String volume, String bucket) throws IOException {
        List<SnapshotInfo> expectedLastNSnapshotsInChain = this.getLastNSnapshotInChain(volume, bucket);
        if (expectedLastNSnapshotsInChain.size() != this.previousOmSnapshots.size()) {
            return false;
        }
        int i = 0;
        while (i < expectedLastNSnapshotsInChain.size()) {
            UUID existingOmSnapshotId;
            SnapshotInfo snapshotInfo = expectedLastNSnapshotsInChain.get(i);
            UncheckedAutoCloseableSupplier<OmSnapshot> omSnapshot = this.previousOmSnapshots.get(i);
            UUID snapshotId = snapshotInfo == null ? null : snapshotInfo.getSnapshotId();
            UUID uUID = existingOmSnapshotId = omSnapshot == null ? null : ((OmSnapshot)omSnapshot.get()).getSnapshotID();
            if (!Objects.equals(snapshotId, existingOmSnapshotId)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void initializePreviousSnapshotsFromChain(String volume, String bucket) throws IOException {
        this.close();
        try {
            List<SnapshotInfo> expectedLastNSnapshotsInChain = this.getLastNSnapshotInChain(volume, bucket);
            for (SnapshotInfo snapshotInfo : expectedLastNSnapshotsInChain) {
                this.lockedSnapshotIds.add(snapshotInfo == null ? null : snapshotInfo.getSnapshotId());
            }
            this.lockedSnapshotIds.add(this.currentSnapshotInfo == null ? null : this.currentSnapshotInfo.getSnapshotId());
            if (!this.snapshotIdLocks.acquireLock(this.lockedSnapshotIds).isLockAcquired()) {
                throw new IOException("Lock acquisition failed for last N snapshots: " + expectedLastNSnapshotsInChain + ", " + this.currentSnapshotInfo);
            }
            for (SnapshotInfo snapshotInfo : expectedLastNSnapshotsInChain) {
                if (snapshotInfo != null) {
                    this.previousOmSnapshots.add(this.omSnapshotManager.getActiveSnapshot(snapshotInfo.getVolumeName(), snapshotInfo.getBucketName(), snapshotInfo.getName()));
                    this.previousSnapshotInfos.add(snapshotInfo);
                    continue;
                }
                this.previousOmSnapshots.add(null);
                this.previousSnapshotInfos.add(null);
            }
            try {
                this.bucketInfo = this.ozoneManager.getBucketManager().getBucketInfo(volume, bucket);
                this.volumeId = this.ozoneManager.getMetadataManager().getVolumeId(volume);
            }
            catch (OMException e) {
                if (OMException.ResultCodes.VOLUME_NOT_FOUND == e.getResult() || OMException.ResultCodes.BUCKET_NOT_FOUND == e.getResult()) {
                    this.bucketInfo = null;
                    this.volumeId = null;
                    return;
                }
                throw e;
            }
        }
        catch (IOException e) {
            this.cleanup();
            throw e;
        }
    }

    public synchronized Boolean apply(Table.KeyValue<String, V> keyValue) throws IOException {
        boolean isReclaimable;
        String bucket;
        String volume = this.getVolumeName(keyValue);
        if (!this.validateExistingLastNSnapshotsInChain(volume, bucket = this.getBucketName(keyValue)) || !this.snapshotIdLocks.isLockAcquired()) {
            this.initializePreviousSnapshotsFromChain(volume, bucket);
        }
        boolean bl = isReclaimable = this.bucketInfo == null || this.isReclaimable(keyValue) != false;
        if (isReclaimable && this.validateExistingLastNSnapshotsInChain(volume, bucket)) {
            return true;
        }
        return false;
    }

    protected abstract String getVolumeName(Table.KeyValue<String, V> var1) throws IOException;

    protected abstract String getBucketName(Table.KeyValue<String, V> var1) throws IOException;

    protected abstract Boolean isReclaimable(Table.KeyValue<String, V> var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    private void cleanup() {
        this.snapshotIdLocks.releaseLock();
        IOUtils.close((Logger)LOG, this.previousOmSnapshots);
        this.previousOmSnapshots.clear();
        this.previousSnapshotInfos.clear();
        this.lockedSnapshotIds.clear();
    }

    protected UncheckedAutoCloseableSupplier<OmSnapshot> getPreviousOmSnapshot(int index) {
        return this.previousOmSnapshots.get(index);
    }

    protected KeyManager getKeyManager() {
        return this.keyManager;
    }

    protected Long getVolumeId() {
        return this.volumeId;
    }

    protected OmBucketInfo getBucketInfo() {
        return this.bucketInfo;
    }

    protected SnapshotInfo getPreviousSnapshotInfo(int index) {
        return this.previousSnapshotInfos.get(index);
    }

    protected OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    List<SnapshotInfo> getPreviousSnapshotInfos() {
        return this.previousSnapshotInfos;
    }

    List<UncheckedAutoCloseableSupplier<OmSnapshot>> getPreviousOmSnapshots() {
        return this.previousOmSnapshots;
    }
}

