/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.util.List;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;

public class PlacementPolicyValidateProxy {
    private PlacementPolicy defaultPlacementPolicy;
    private PlacementPolicy ecPlacementPolicy;

    public PlacementPolicyValidateProxy(PlacementPolicy defaultPlacementPolicy, PlacementPolicy ecPlacementPolicy) {
        this.defaultPlacementPolicy = defaultPlacementPolicy;
        this.ecPlacementPolicy = ecPlacementPolicy;
    }

    public ContainerPlacementStatus validateContainerPlacement(List<DatanodeDetails> replicaList, ContainerInfo cInfo) {
        switch (cInfo.getReplicationType()) {
            case EC: {
                return this.ecPlacementPolicy.validateContainerPlacement(replicaList, cInfo.getReplicationConfig().getRequiredNodes());
            }
        }
        return this.defaultPlacementPolicy.validateContainerPlacement(replicaList, cInfo.getReplicationConfig().getRequiredNodes());
    }
}

