/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.replication;

import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationManagerEventHandler
implements EventHandler<DatanodeDetails> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationManagerEventHandler.class);
    private final ReplicationManager replicationManager;
    private final SCMContext scmContext;

    public ReplicationManagerEventHandler(ReplicationManager replicationManager, SCMContext scmContext) {
        this.replicationManager = replicationManager;
        this.scmContext = scmContext;
    }

    public void onMessage(DatanodeDetails datanodeDetails, EventPublisher eventPublisher) {
        if (!this.scmContext.isLeaderReady() || this.scmContext.isInSafeMode()) {
            return;
        }
        LOG.debug("ReplicationManagerEventHandler received event for datanode: {}", (Object)datanodeDetails);
        this.replicationManager.notifyNodeStateChange();
    }
}

