/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.DatanodeID;
import org.apache.hadoop.hdds.protocol.ReconfigureProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.ReconfigureProtocolProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolPB;
import org.apache.hadoop.hdds.protocolPB.ReconfigureProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.RatisHelper;
import org.apache.hadoop.hdds.scm.DatanodeAdminError;
import org.apache.hadoop.hdds.scm.FetchMetrics;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerListResult;
import org.apache.hadoop.hdds.scm.container.ContainerNotFoundException;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.ReplicationManagerReport;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancer;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerConfiguration;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancerStatusInfo;
import org.apache.hadoop.hdds.scm.container.balancer.IllegalContainerBalancerStateException;
import org.apache.hadoop.hdds.scm.container.balancer.InvalidContainerBalancerConfigurationException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.reconciliation.ReconciliationEligibilityHandler;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.HASecurityUtils;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeStatus;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineNotFoundException;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.scm.server.SCMPolicyProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.ProtocolMessageMetrics;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.SCMAction;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.Token;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMClientProtocolServer
implements StorageContainerLocationProtocol,
Auditor {
    private static final Logger LOG = LoggerFactory.getLogger(SCMClientProtocolServer.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.SCMLOGGER);
    private final RPC.Server clientRpcServer;
    private final InetSocketAddress clientRpcAddress;
    private final StorageContainerManager scm;
    private final OzoneConfiguration config;
    private final ProtocolMessageMetrics<ProtocolMessageEnum> protocolMetrics;

    public SCMClientProtocolServer(OzoneConfiguration conf, StorageContainerManager scm, ReconfigurationHandler reconfigurationHandler) throws IOException {
        this.scm = scm;
        this.config = conf;
        int handlerCount = conf.getInt("ozone.scm.client.handler.count.key", "ozone.scm.handler.count.key", 100, arg_0 -> ((Logger)LOG).info(arg_0));
        int readThreads = conf.getInt("ozone.scm.client.read.threadpool", 10);
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        this.protocolMetrics = ProtocolMessageMetrics.create((String)"ScmContainerLocationProtocol", (String)"SCM ContainerLocation protocol metrics", (Object[])StorageContainerLocationProtocolProtos.Type.values());
        BlockingService storageProtoPbService = StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.newReflectiveBlockingService((StorageContainerLocationProtocolProtos.StorageContainerLocationProtocolService.BlockingInterface)new StorageContainerLocationProtocolServerSideTranslatorPB(this, scm, this.protocolMetrics));
        InetSocketAddress scmAddress = scm.getScmNodeDetails().getClientProtocolServerAddress();
        this.clientRpcServer = StorageContainerManager.startRpcServer(conf, scmAddress, StorageContainerLocationProtocolPB.class, storageProtoPbService, handlerCount, readThreads);
        ReconfigureProtocolServerSideTranslatorPB reconfigureServerProtocol = new ReconfigureProtocolServerSideTranslatorPB((ReconfigureProtocol)reconfigurationHandler);
        BlockingService reconfigureService = ReconfigureProtocolProtos.ReconfigureProtocolService.newReflectiveBlockingService((ReconfigureProtocolProtos.ReconfigureProtocolService.BlockingInterface)reconfigureServerProtocol);
        HddsServerUtil.addPBProtocol((Configuration)conf, ReconfigureProtocolPB.class, (BlockingService)reconfigureService, (RPC.Server)this.clientRpcServer);
        this.clientRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)conf, (String)scm.getScmNodeDetails().getClientProtocolServerAddressKey(), (InetSocketAddress)scmAddress, (RPC.Server)this.clientRpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.clientRpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)SCMPolicyProvider.getInstance());
        }
        HddsServerUtil.addSuppressedLoggingExceptions((RPC.Server)this.clientRpcServer);
    }

    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    public InetSocketAddress getClientRpcAddress() {
        return this.clientRpcAddress;
    }

    public void start() {
        this.protocolMetrics.register();
        LOG.info(StorageContainerManager.buildRpcServerStartMessage("RPC server for Client ", this.getClientRpcAddress()));
        this.getClientRpcServer().start();
    }

    public void stop() {
        this.protocolMetrics.unregister();
        try {
            LOG.info("Stopping the RPC server for Client Protocol");
            this.getClientRpcServer().stop();
        }
        catch (Exception ex) {
            LOG.error("Client Protocol RPC stop failed.", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{this.scm.getScmNodeManager()});
    }

    public void join() throws InterruptedException {
        LOG.trace("Join RPC server for Client Protocol");
        this.getClientRpcServer().join();
    }

    public ContainerWithPipeline allocateContainer(HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor factor, String owner) throws IOException {
        ReplicationConfig replicationConfig = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)replicationType, (HddsProtos.ReplicationFactor)factor);
        return this.allocateContainer(replicationConfig, owner);
    }

    public ContainerWithPipeline allocateContainer(ReplicationConfig replicationConfig, String owner) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("replicationType", String.valueOf(replicationConfig.getReplicationType()));
        auditMap.put("replication", String.valueOf(replicationConfig.getReplication()));
        auditMap.put("owner", String.valueOf(owner));
        try {
            if (this.scm.getScmContext().isInSafeMode()) {
                throw new SCMException("SafeModePrecheck failed for allocateContainer", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
            }
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            ContainerInfo container = this.scm.getContainerManager().allocateContainer(replicationConfig, owner);
            Pipeline pipeline = this.scm.getPipelineManager().getPipeline(container.getPipelineID());
            ContainerWithPipeline cp = new ContainerWithPipeline(container, pipeline);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.ALLOCATE_CONTAINER, auditMap));
            return cp;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.ALLOCATE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public ContainerInfo getContainer(long containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            ContainerInfo info = this.scm.getContainerManager().getContainer(ContainerID.valueOf((long)containerID));
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER, auditMap));
            return info;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    private ContainerWithPipeline getContainerWithPipelineCommon(long containerID) throws IOException {
        Pipeline pipeline;
        ContainerID cid = ContainerID.valueOf((long)containerID);
        ContainerInfo container = this.scm.getContainerManager().getContainer(cid);
        if (this.scm.getScmContext().isInSafeMode() && container.isOpen() && !this.hasRequiredReplicas(container)) {
            throw new SCMException("Open container " + containerID + " doesn't have enough replicas to service this operation in Safe mode.", SCMException.ResultCodes.SAFE_MODE_EXCEPTION);
        }
        try {
            pipeline = container.isOpen() ? this.scm.getPipelineManager().getPipeline(container.getPipelineID()) : null;
        }
        catch (PipelineNotFoundException ex) {
            pipeline = null;
        }
        if (pipeline == null) {
            pipeline = this.scm.getPipelineManager().createPipelineForRead(container.getReplicationConfig(), this.scm.getContainerManager().getContainerReplicas(cid));
        }
        return new ContainerWithPipeline(container, pipeline);
    }

    public ContainerWithPipeline getContainerWithPipeline(long containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", ContainerID.valueOf((long)containerID).toString());
        try {
            ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_WITH_PIPELINE, auditMap));
            return cp;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_WITH_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public List<HddsProtos.SCMContainerReplicaProto> getContainerReplicas(long containerId, int clientVersion) throws IOException {
        ArrayList<HddsProtos.SCMContainerReplicaProto> results = new ArrayList<HddsProtos.SCMContainerReplicaProto>();
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("containerId", String.valueOf(containerId));
        auditMap.put("clientVersion", String.valueOf(clientVersion));
        try {
            Set<ContainerReplica> replicas = this.getScm().getContainerManager().getContainerReplicas(ContainerID.valueOf((long)containerId));
            for (ContainerReplica r : replicas) {
                results.add(HddsProtos.SCMContainerReplicaProto.newBuilder().setContainerID(containerId).setState(r.getState().toString()).setDatanodeDetails(r.getDatanodeDetails().toProto(clientVersion)).setBytesUsed(r.getBytesUsed()).setPlaceOfBirth(r.getOriginDatanodeId().toString()).setKeyCount(r.getKeyCount()).setSequenceID(r.getSequenceId().longValue()).setReplicaIndex((long)r.getReplicaIndex()).setDataChecksum(r.getDataChecksum()).build());
            }
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, auditMap));
            return results;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_REPLICAS, auditMap, ex));
            throw ex;
        }
    }

    public List<ContainerWithPipeline> getContainerWithPipelineBatch(Iterable<? extends Long> containerIDs) throws IOException {
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        StringBuilder strContainerIDs = new StringBuilder();
        for (Long l : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(l);
                cpList.add(cp);
                strContainerIDs.append(ContainerID.valueOf((long)l).toString());
                strContainerIDs.append(',');
            }
            catch (IOException ex) {
                AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerID", ContainerID.valueOf((long)l).toString()), ex));
                throw ex;
            }
        }
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_WITH_PIPELINE_BATCH, Collections.singletonMap("containerIDs", strContainerIDs.toString())));
        return cpList;
    }

    public List<ContainerWithPipeline> getExistContainerWithPipelinesInBatch(List<Long> containerIDs) {
        ArrayList<ContainerWithPipeline> cpList = new ArrayList<ContainerWithPipeline>();
        for (Long containerID : containerIDs) {
            try {
                ContainerWithPipeline cp = this.getContainerWithPipelineCommon(containerID);
                cpList.add(cp);
            }
            catch (IOException ex) {
                LOG.error("Container with common pipeline not found: {}", (Throwable)ex);
            }
        }
        return cpList;
    }

    private boolean hasRequiredReplicas(ContainerInfo contInfo) {
        try {
            return this.getScm().getContainerManager().getContainerReplicas(contInfo.containerID()).size() >= contInfo.getReplicationConfig().getRequiredNodes();
        }
        catch (ContainerNotFoundException ex) {
            return false;
        }
    }

    public ContainerListResult listContainer(long startContainerID, int count) throws IOException {
        return this.listContainer(startContainerID, count, null, null, null);
    }

    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        return this.listContainer(startContainerID, count, state, null, null);
    }

    @Deprecated
    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationFactor factor) throws IOException {
        return this.listContainerInternal(startContainerID, count, state, factor, null, null);
    }

    private ContainerListResult listContainerInternal(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType replicationType, ReplicationConfig repConfig) throws IOException {
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(startContainerID, count, state, factor, replicationType, repConfig);
        try {
            Stream<ContainerInfo> containerStream = this.buildContainerStream(factor, replicationType, repConfig, this.getBaseContainerStream(state));
            List containerInfos = containerStream.filter(info -> info.containerID().getId() >= startContainerID).sorted().collect(Collectors.toList());
            List limitedContainers = containerInfos.stream().limit(count).collect(Collectors.toList());
            long totalCount = containerInfos.size();
            ContainerListResult containerListResult = new ContainerListResult(limitedContainers, totalCount);
            return containerListResult;
        }
        catch (Exception ex) {
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_CONTAINER, auditMap));
            }
        }
    }

    private Stream<ContainerInfo> buildContainerStream(HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType replicationType, ReplicationConfig repConfig, Stream<ContainerInfo> containerStream) {
        if (factor != null) {
            containerStream = containerStream.filter(info -> info.getReplicationType() != HddsProtos.ReplicationType.EC).filter(info -> info.getReplicationFactor() == factor);
        } else if (repConfig != null) {
            containerStream = containerStream.filter(info -> info.getReplicationConfig().equals((Object)repConfig));
        } else if (replicationType != null) {
            containerStream = containerStream.filter(info -> info.getReplicationType() == replicationType);
        }
        return containerStream;
    }

    private Stream<ContainerInfo> getBaseContainerStream(HddsProtos.LifeCycleState state) {
        if (state != null) {
            return this.scm.getContainerManager().getContainers(state).stream();
        }
        return this.scm.getContainerManager().getContainers().stream();
    }

    private Map<String, String> buildAuditMap(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType replicationType, ReplicationConfig repConfig) {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        if (state != null) {
            auditMap.put("state", state.name());
        }
        if (factor != null) {
            auditMap.put("factor", factor.name());
        }
        if (replicationType != null) {
            auditMap.put("replicationType", replicationType.toString());
        }
        if (repConfig != null) {
            auditMap.put("replicationConfig", repConfig.toString());
        }
        return auditMap;
    }

    public ContainerListResult listContainer(long startContainerID, int count, HddsProtos.LifeCycleState state, HddsProtos.ReplicationType replicationType, ReplicationConfig repConfig) throws IOException {
        return this.listContainerInternal(startContainerID, count, state, null, replicationType, repConfig);
    }

    public void deleteContainer(long containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.getScm().checkAdminAccess(remoteUser, false);
            this.scm.getContainerManager().deleteContainer(ContainerID.valueOf((long)containerID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DELETE_CONTAINER, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DELETE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public Map<String, List<ContainerID>> getContainersOnDecomNode(DatanodeDetails dn) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("datanodeDetails", String.valueOf(dn));
        try {
            Map<String, List<ContainerID>> result = this.scm.getScmDecommissionManager().getContainersPendingReplication(dn);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINERS_ON_DECOM_NODE, auditMap));
            return result;
        }
        catch (NodeNotFoundException e) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINERS_ON_DECOM_NODE, auditMap, e));
            throw new IOException("Failed to get containers list. Unable to find required node", e);
        }
    }

    public List<HddsProtos.Node> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state, HddsProtos.QueryScope queryScope, String poolName, int clientVersion) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("opState", String.valueOf(opState));
        auditMap.put("state", String.valueOf(state));
        auditMap.put("queryScope", String.valueOf(queryScope));
        auditMap.put("poolName", poolName);
        auditMap.put("clientVersion", String.valueOf(clientVersion));
        if (queryScope == HddsProtos.QueryScope.POOL) {
            IllegalArgumentException ex = new IllegalArgumentException("Not Supported yet");
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.QUERY_NODE, auditMap, ex));
            throw ex;
        }
        try {
            ArrayList<HddsProtos.Node> result = new ArrayList<HddsProtos.Node>();
            for (DatanodeDetails node : this.queryNode(opState, state)) {
                NodeStatus ns = this.scm.getScmNodeManager().getNodeStatus(node);
                result.add(HddsProtos.Node.newBuilder().setNodeID(node.toProto(clientVersion)).addNodeStates(ns.getHealth()).addNodeOperationalStates(ns.getOperationalState()).build());
            }
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.QUERY_NODE, auditMap));
            return result;
        }
        catch (NodeNotFoundException e) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.QUERY_NODE, auditMap, e));
            throw new IOException("An unexpected error occurred querying the NodeStatus", e);
        }
    }

    public HddsProtos.Node queryNode(UUID uuid) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("uuid", String.valueOf(uuid));
        HddsProtos.Node result = null;
        try {
            DatanodeDetails node = this.scm.getScmNodeManager().getNode(DatanodeID.of((UUID)uuid));
            if (node != null) {
                NodeStatus ns = this.scm.getScmNodeManager().getNodeStatus(node);
                result = HddsProtos.Node.newBuilder().setNodeID(node.getProtoBufMessage()).addNodeStates(ns.getHealth()).addNodeOperationalStates(ns.getOperationalState()).build();
            }
        }
        catch (NodeNotFoundException e) {
            IOException ex = new IOException("An unexpected error occurred querying the NodeStatus", e);
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.QUERY_NODE, auditMap, ex));
            throw ex;
        }
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.QUERY_NODE, auditMap));
        return result;
    }

    public List<DatanodeAdminError> decommissionNodes(List<String> nodes, boolean force) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("nodes", String.valueOf(nodes));
        auditMap.put("force", String.valueOf(force));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            List<DatanodeAdminError> result = this.scm.getScmDecommissionManager().decommissionNodes(nodes, force);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DECOMMISSION_NODES, auditMap));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DECOMMISSION_NODES, auditMap, ex));
            throw ex;
        }
    }

    public List<DatanodeAdminError> recommissionNodes(List<String> nodes) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("nodes", String.valueOf(nodes));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            List<DatanodeAdminError> result = this.scm.getScmDecommissionManager().recommissionNodes(nodes);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DECOMMISSION_NODES, auditMap));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DECOMMISSION_NODES, auditMap, ex));
            throw ex;
        }
    }

    public List<DatanodeAdminError> startMaintenanceNodes(List<String> nodes, int endInHours, boolean force) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("nodes", String.valueOf(nodes));
        auditMap.put("endInHours", String.valueOf(endInHours));
        auditMap.put("force", String.valueOf(force));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            List<DatanodeAdminError> result = this.scm.getScmDecommissionManager().startMaintenanceNodes(nodes, endInHours, force);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.START_MAINTENANCE_NODES, auditMap));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.START_MAINTENANCE_NODES, auditMap, ex));
            throw ex;
        }
    }

    public void closeContainer(long containerID) throws IOException {
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            this.scm.checkAdminAccess(remoteUser, false);
            ContainerID cid = ContainerID.valueOf((long)containerID);
            HddsProtos.LifeCycleState state = this.scm.getContainerManager().getContainer(cid).getState();
            if (!state.equals((Object)HddsProtos.LifeCycleState.OPEN)) {
                SCMException.ResultCodes resultCode = SCMException.ResultCodes.UNEXPECTED_CONTAINER_STATE;
                if (state.equals((Object)HddsProtos.LifeCycleState.CLOSED)) {
                    resultCode = SCMException.ResultCodes.CONTAINER_ALREADY_CLOSED;
                }
                if (state.equals((Object)HddsProtos.LifeCycleState.CLOSING)) {
                    resultCode = SCMException.ResultCodes.CONTAINER_ALREADY_CLOSING;
                }
                throw new SCMException("Cannot close a " + state + " container.", resultCode);
            }
            this.scm.getEventQueue().fireEvent(SCMEvents.CLOSE_CONTAINER, (Object)ContainerID.valueOf((long)containerID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CLOSE_CONTAINER, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CLOSE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public Pipeline createReplicationPipeline(HddsProtos.ReplicationType type, HddsProtos.ReplicationFactor factor, HddsProtos.NodePool nodePool) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        if (type != null) {
            auditMap.put("replicationType", type.toString());
        }
        if (factor != null) {
            auditMap.put("replicationFactor", factor.toString());
        }
        if (nodePool != null && !nodePool.getNodesList().isEmpty()) {
            ArrayList<String> nodeIpAddresses = new ArrayList<String>();
            for (HddsProtos.Node node : nodePool.getNodesList()) {
                nodeIpAddresses.add(node.getNodeID().getIpAddress());
            }
            auditMap.put("nodePool", String.join((CharSequence)", ", nodeIpAddresses));
        }
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            Pipeline result = this.scm.getPipelineManager().createPipeline(ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)type, (HddsProtos.ReplicationFactor)factor));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CREATE_PIPELINE, auditMap));
            return result;
        }
        catch (SCMException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CREATE_PIPELINE, auditMap, e));
            throw e;
        }
    }

    public List<Pipeline> listPipelines() throws IOException {
        try {
            List<Pipeline> pipelines = this.scm.getPipelineManager().getPipelines();
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_PIPELINE, null));
            return pipelines;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.LIST_PIPELINE, null, ex));
            throw ex;
        }
    }

    public Pipeline getPipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        try {
            Pipeline pipeline = this.scm.getPipelineManager().getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_PIPELINE, auditMap));
            return pipeline;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public void activatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getPipelineManager().activatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.ACTIVATE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.ACTIVATE_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public void deactivatePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("pipelineID", pipelineID.getId());
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getPipelineManager().deactivatePipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DEACTIVATE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DEACTIVATE_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public void closePipeline(HddsProtos.PipelineID pipelineID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            auditMap.put("pipelineID", pipelineID.getId());
            PipelineManager pipelineManager = this.scm.getPipelineManager();
            Pipeline pipeline = pipelineManager.getPipeline(PipelineID.getFromProtobuf((HddsProtos.PipelineID)pipelineID));
            pipelineManager.closePipeline(pipeline.getId());
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.CLOSE_PIPELINE, auditMap));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.CLOSE_PIPELINE, auditMap, ex));
            throw ex;
        }
    }

    public ScmInfo getScmInfo() {
        try {
            ScmInfo.Builder builder = new ScmInfo.Builder().setClusterId(this.scm.getScmStorageConfig().getClusterID()).setScmId(this.scm.getScmStorageConfig().getScmId()).setPeerRoles(this.scm.getScmHAManager().getRatisServer().getRatisRoles());
            ScmInfo info = builder.build();
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_SCM_INFO, null));
            return info;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_SCM_INFO, null, ex));
            throw ex;
        }
    }

    public void transferLeadership(String newLeaderId) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("newLeaderId", newLeaderId);
        try {
            RaftPeerId targetPeerId;
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            ScmUtils.checkIfCertSignRequestAllowed(this.scm.getRootCARotationManager(), false, this.config, "transferLeadership");
            SCMRatisServer scmRatisServer = this.scm.getScmHAManager().getRatisServer();
            RaftGroup group = scmRatisServer.getDivision().getGroup();
            if (newLeaderId.isEmpty()) {
                RaftPeer curLeader = ((SCMRatisServerImpl)this.scm.getScmHAManager().getRatisServer()).getLeader();
                targetPeerId = group.getPeers().stream().filter(a -> !a.equals((Object)curLeader)).findFirst().map(RaftPeer::getId).orElseThrow(() -> new IOException("Cannot find a new leader to transfer leadership."));
            } else {
                targetPeerId = RaftPeerId.valueOf((String)newLeaderId);
            }
            GrpcTlsConfig tlsConfig = HASecurityUtils.createSCMRatisTLSConfig(new SecurityConfig((ConfigurationSource)this.scm.getConfiguration()), this.scm.getScmCertificateClient());
            RatisHelper.transferRatisLeadership((ConfigurationSource)this.scm.getConfiguration(), (RaftGroup)group, (RaftPeerId)targetPeerId, (GrpcTlsConfig)tlsConfig);
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.TRANSFER_LEADERSHIP, auditMap, ex));
            throw ex;
        }
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.TRANSFER_LEADERSHIP, auditMap));
    }

    @Deprecated
    public List<HddsProtos.DeletedBlocksTransactionInfo> getFailedDeletedBlockTxn(int count, long startTxId) throws IOException {
        return Collections.emptyList();
    }

    @Deprecated
    public int resetDeletedBlockRetryCount(List<Long> txIDs) throws IOException {
        return 0;
    }

    public boolean inSafeMode() throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.IN_SAFE_MODE, null));
        return this.scm.isInSafeMode();
    }

    public Map<String, Pair<Boolean, String>> getSafeModeRuleStatuses() throws IOException {
        try {
            Map<String, Pair<Boolean, String>> result = this.scm.getRuleStatus();
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_SAFE_MODE_RULE_STATUSES, null));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_SAFE_MODE_RULE_STATUSES, null, ex));
            throw ex;
        }
    }

    public boolean forceExitSafeMode() throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            boolean result = this.scm.exitSafeMode();
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.FORCE_EXIT_SAFE_MODE, null));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.FORCE_EXIT_SAFE_MODE, null, ex));
            throw ex;
        }
    }

    public void startReplicationManager() throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getReplicationManager().start();
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.START_REPLICATION_MANAGER, null));
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.START_REPLICATION_MANAGER, null, ex));
            throw ex;
        }
    }

    public void stopReplicationManager() throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.STOP_REPLICATION_MANAGER, null));
            this.scm.getReplicationManager().stop();
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.STOP_REPLICATION_MANAGER, null, ex));
            throw ex;
        }
    }

    public boolean getReplicationManagerStatus() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_REPLICATION_MANAGER_STATUS, null));
        return this.scm.getReplicationManager().isRunning();
    }

    public ReplicationManagerReport getReplicationManagerReport() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_REPLICATION_MANAGER_REPORT, null));
        return this.scm.getReplicationManager().getContainerReport();
    }

    public UpgradeFinalization.StatusAndMessages finalizeScmUpgrade(String upgradeClientID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("upgradeClientID", upgradeClientID);
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            UpgradeFinalization.StatusAndMessages result = this.scm.getFinalizationManager().finalizeUpgrade(upgradeClientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.FINALIZE_SCM_UPGRADE, auditMap));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.FINALIZE_SCM_UPGRADE, auditMap, ex));
            throw ex;
        }
    }

    public UpgradeFinalization.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean force, boolean readonly) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("upgradeClientID", upgradeClientID);
        auditMap.put("force", String.valueOf(force));
        auditMap.put("readonly", String.valueOf(readonly));
        try {
            if (!readonly) {
                this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            }
            UpgradeFinalization.StatusAndMessages result = this.scm.getFinalizationManager().queryUpgradeFinalizationProgress(upgradeClientID, force, readonly);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.QUERY_UPGRADE_FINALIZATION_PROGRESS, auditMap));
            return result;
        }
        catch (IOException ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.QUERY_UPGRADE_FINALIZATION_PROGRESS, auditMap, ex));
            throw ex;
        }
    }

    public StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto startContainerBalancer(Optional<Double> threshold, Optional<Integer> iterations, Optional<Integer> maxDatanodesPercentageToInvolvePerIteration, Optional<Long> maxSizeToMovePerIterationInGB, Optional<Long> maxSizeEnteringTarget, Optional<Long> maxSizeLeavingSource, Optional<Integer> balancingInterval, Optional<Integer> moveTimeout, Optional<Integer> moveReplicationTimeout, Optional<Boolean> networkTopologyEnable, Optional<String> includeNodes, Optional<String> excludeNodes) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            ContainerBalancerConfiguration cbc = (ContainerBalancerConfiguration)this.scm.getConfiguration().getObject(ContainerBalancerConfiguration.class);
            if (threshold.isPresent()) {
                double tsd = threshold.get();
                auditMap.put("threshold", String.valueOf(tsd));
                if (tsd < 0.0 || tsd >= 100.0) {
                    throw new IOException("Threshold should be specified in the range [0.0, 100.0).");
                }
                cbc.setThreshold(tsd);
            }
            if (maxSizeToMovePerIterationInGB.isPresent()) {
                long mstm = maxSizeToMovePerIterationInGB.get();
                auditMap.put("maxSizeToMovePerIterationInGB", String.valueOf(mstm));
                if (mstm <= 0L) {
                    throw new IOException("Max Size To Move Per Iteration In GB must be positive.");
                }
                cbc.setMaxSizeToMovePerIteration(mstm * 0x40000000L);
            }
            if (maxDatanodesPercentageToInvolvePerIteration.isPresent()) {
                int mdti = maxDatanodesPercentageToInvolvePerIteration.get();
                auditMap.put("maxDatanodesPercentageToInvolvePerIteration", String.valueOf(mdti));
                if (mdti < 0 || mdti > 100) {
                    throw new IOException("Max Datanodes Percentage To Involve Per Iterationshould be specified in the range [0, 100]");
                }
                cbc.setMaxDatanodesPercentageToInvolvePerIteration(mdti);
            }
            if (iterations.isPresent()) {
                int i = iterations.get();
                auditMap.put("iterations", String.valueOf(i));
                if (i < -1 || i == 0) {
                    throw new IOException("Number of Iterations must be positive or -1 (for running container balancer infinitely).");
                }
                cbc.setIterations(i);
            }
            if (maxSizeEnteringTarget.isPresent()) {
                long mset = maxSizeEnteringTarget.get();
                auditMap.put("maxSizeEnteringTarget", String.valueOf(mset));
                if (mset <= 0L) {
                    throw new IOException("Max Size Entering Target must be greater than zero.");
                }
                cbc.setMaxSizeEnteringTarget(mset * 0x40000000L);
            }
            if (maxSizeLeavingSource.isPresent()) {
                long msls = maxSizeLeavingSource.get();
                auditMap.put("maxSizeLeavingSource", String.valueOf(msls));
                if (msls <= 0L) {
                    throw new IOException("Max Size Leaving Source must be greater than zero.");
                }
                cbc.setMaxSizeLeavingSource(msls * 0x40000000L);
            }
            if (balancingInterval.isPresent()) {
                int bi = balancingInterval.get();
                auditMap.put("balancingInterval", String.valueOf(bi));
                if (bi <= 0) {
                    throw new IOException("Balancing Interval must be greater than zero.");
                }
                cbc.setBalancingInterval(Duration.ofMinutes(bi));
            }
            if (moveTimeout.isPresent()) {
                int mt = moveTimeout.get();
                auditMap.put("moveTimeout", String.valueOf(mt));
                if (mt <= 0) {
                    throw new IOException("Move Timeout must be greater than zero.");
                }
                cbc.setMoveTimeout(Duration.ofMinutes(mt));
            }
            if (moveReplicationTimeout.isPresent()) {
                int mrt = moveReplicationTimeout.get();
                auditMap.put("moveReplicationTimeout", String.valueOf(mrt));
                if (mrt <= 0) {
                    throw new IOException("Move Replication Timeout must be greater than zero.");
                }
                cbc.setMoveReplicationTimeout(Duration.ofMinutes(mrt));
            }
            if (networkTopologyEnable.isPresent()) {
                Boolean nt = networkTopologyEnable.get();
                auditMap.put("networkTopologyEnable", String.valueOf(nt));
                cbc.setNetworkTopologyEnable(nt);
            }
            if (includeNodes.isPresent()) {
                String in = includeNodes.get();
                auditMap.put("includeNodes", in);
                cbc.setIncludeNodes(in);
            }
            if (excludeNodes.isPresent()) {
                String ex = excludeNodes.get();
                auditMap.put("excludeNodes", ex);
                cbc.setExcludeNodes(ex);
            }
            ContainerBalancer containerBalancer = this.scm.getContainerBalancer();
            containerBalancer.startBalancer(cbc);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.START_CONTAINER_BALANCER, auditMap));
            return StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto.newBuilder().setStart(true).build();
        }
        catch (IOException | IllegalContainerBalancerStateException | InvalidContainerBalancerConfigurationException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.START_CONTAINER_BALANCER, auditMap, e));
            return StorageContainerLocationProtocolProtos.StartContainerBalancerResponseProto.newBuilder().setStart(false).setMessage(e.getMessage()).build();
        }
    }

    public void stopContainerBalancer() throws IOException {
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            this.scm.getContainerBalancer().stopBalancer();
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.STOP_CONTAINER_BALANCER, null));
        }
        catch (IllegalContainerBalancerStateException e) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.STOP_CONTAINER_BALANCER, null, e));
            throw new IOException(e.getMessage(), e);
        }
    }

    public boolean getContainerBalancerStatus() {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_BALANCER_STATUS, null));
        return this.scm.getContainerBalancer().isBalancerRunning();
    }

    public StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto getContainerBalancerStatusInfo() throws IOException {
        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_BALANCER_STATUS_INFO, null));
        ContainerBalancerStatusInfo balancerStatusInfo = this.scm.getContainerBalancer().getBalancerStatusInfo();
        if (balancerStatusInfo == null) {
            return StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto.newBuilder().setIsRunning(false).build();
        }
        return StorageContainerLocationProtocolProtos.ContainerBalancerStatusInfoResponseProto.newBuilder().setIsRunning(true).setContainerBalancerStatusInfo(balancerStatusInfo.toProto()).build();
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(String address, String uuid, int clientVersion) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("address", address);
        auditMap.put("uuid", uuid);
        auditMap.put("clientVersion", String.valueOf(clientVersion));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            List<Object> nodes = new ArrayList<DatanodeDetails>();
            if (!Strings.isNullOrEmpty((String)uuid)) {
                nodes.add(this.scm.getScmNodeManager().getNode(DatanodeID.fromUuidString((String)uuid)));
            } else if (!Strings.isNullOrEmpty((String)address)) {
                nodes = this.scm.getScmNodeManager().getNodesByAddress(address);
            } else {
                throw new IOException("Could not get datanode with the specified parameters.");
            }
            ArrayList<HddsProtos.DatanodeUsageInfoProto> infoList = new ArrayList<HddsProtos.DatanodeUsageInfoProto>();
            for (DatanodeDetails datanodeDetails : nodes) {
                infoList.add(this.getUsageInfoFromDatanodeDetails(datanodeDetails, clientVersion));
            }
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_DATANODE_USAGE_INFO, auditMap));
            return infoList;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_DATANODE_USAGE_INFO, auditMap, ex));
            throw ex;
        }
    }

    private HddsProtos.DatanodeUsageInfoProto getUsageInfoFromDatanodeDetails(DatanodeDetails node, int clientVersion) {
        DatanodeUsageInfo usageInfo = this.scm.getScmNodeManager().getUsageInfo(node);
        return usageInfo.toProto(clientVersion);
    }

    public List<HddsProtos.DatanodeUsageInfoProto> getDatanodeUsageInfo(boolean mostUsed, int count, int clientVersion) throws IOException, IllegalArgumentException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("mostUsed", String.valueOf(mostUsed));
        auditMap.put("count", String.valueOf(count));
        auditMap.put("clientVersion", String.valueOf(clientVersion));
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            if (count < 1) {
                throw new IllegalArgumentException("The specified parameter count must be an integer greater than zero.");
            }
            List<DatanodeUsageInfo> datanodeUsageInfoList = this.scm.getScmNodeManager().getMostOrLeastUsedDatanodes(mostUsed);
            if (count > datanodeUsageInfoList.size()) {
                count = datanodeUsageInfoList.size();
            }
            List<HddsProtos.DatanodeUsageInfoProto> result = datanodeUsageInfoList.stream().map(each -> each.toProto(clientVersion)).limit(count).collect(Collectors.toList());
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_DATANODE_USAGE_INFO, auditMap));
            return result;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_DATANODE_USAGE_INFO, auditMap, ex));
            throw ex;
        }
    }

    public Token<?> getContainerToken(ContainerID containerID) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", String.valueOf(containerID));
        try {
            UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), true);
            Token token = this.scm.getContainerTokenGenerator().generateToken(remoteUser.getUserName(), containerID);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_TOKEN, auditMap));
            return token;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_TOKEN, auditMap, ex));
            throw ex;
        }
    }

    public long getContainerCount() throws IOException {
        try {
            long count = this.scm.getContainerManager().getContainers().size();
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_COUNT, null));
            return count;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_COUNT, null, ex));
            throw ex;
        }
    }

    public long getContainerCount(HddsProtos.LifeCycleState state) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("state", String.valueOf(state));
        try {
            long count = this.scm.getContainerManager().getContainers(state).size();
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_CONTAINER_COUNT, auditMap));
            return count;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_CONTAINER_COUNT, auditMap, ex));
            throw ex;
        }
    }

    public List<ContainerInfo> getListOfContainers(long startContainerID, int count, HddsProtos.LifeCycleState state) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("startContainerID", String.valueOf(startContainerID));
        auditMap.put("count", String.valueOf(count));
        auditMap.put("state", String.valueOf(state));
        try {
            List<ContainerInfo> results = this.scm.getContainerManager().getContainers(ContainerID.valueOf((long)startContainerID), count, state);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.LIST_CONTAINER, auditMap));
            return results;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.LIST_CONTAINER, auditMap, ex));
            throw ex;
        }
    }

    public List<DatanodeDetails> queryNode(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState state) {
        return new ArrayList<DatanodeDetails>(this.queryNodeState(opState, state));
    }

    @VisibleForTesting
    public StorageContainerManager getScm() {
        return this.scm;
    }

    public boolean getSafeModeStatus() {
        return this.scm.getScmContext().isInSafeMode();
    }

    private Set<DatanodeDetails> queryNodeState(HddsProtos.NodeOperationalState opState, HddsProtos.NodeState nodeState) {
        TreeSet<DatanodeDetails> returnSet = new TreeSet<DatanodeDetails>();
        List<DatanodeDetails> tmp = this.scm.getScmNodeManager().getNodes(opState, nodeState);
        if (tmp != null && !tmp.isEmpty()) {
            returnSet.addAll(tmp);
        }
        return returnSet;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.SUCCESS).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(ServerUtils.getRemoteUserName()).atIp(Server.getRemoteAddress()).forOperation(op).withParams(auditMap).withResult(AuditEventStatus.FAILURE).withException(throwable).build();
    }

    public void close() throws IOException {
        this.stop();
    }

    public StorageContainerLocationProtocolProtos.DecommissionScmResponseProto decommissionScm(String scmId) {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("scmId", scmId);
        StorageContainerLocationProtocolProtos.DecommissionScmResponseProto.Builder decommissionScmResponseBuilder = StorageContainerLocationProtocolProtos.DecommissionScmResponseProto.newBuilder();
        try {
            this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
            decommissionScmResponseBuilder.setSuccess(this.scm.removePeerFromHARing(scmId));
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.DECOMMISSION_SCM, auditMap));
        }
        catch (IOException ex) {
            decommissionScmResponseBuilder.setSuccess(false).setErrorMsg(ex.getMessage());
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.DECOMMISSION_SCM, auditMap, ex));
        }
        return decommissionScmResponseBuilder.build();
    }

    public String getMetrics(String query) throws IOException {
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("query", query);
        try {
            FetchMetrics fetchMetrics = new FetchMetrics();
            String metrics = fetchMetrics.getMetrics(query);
            AUDIT.logReadSuccess(this.buildAuditMessageForSuccess(SCMAction.GET_METRICS, auditMap));
            return metrics;
        }
        catch (Exception ex) {
            AUDIT.logReadFailure(this.buildAuditMessageForFailure(SCMAction.GET_METRICS, auditMap, ex));
            throw ex;
        }
    }

    public void reconcileContainer(long longContainerID) throws IOException {
        ContainerID containerID = ContainerID.valueOf((long)longContainerID);
        this.getScm().checkAdminAccess(HddsServerUtil.getRemoteUser(), false);
        UserGroupInformation remoteUser = HddsServerUtil.getRemoteUser();
        HashMap auditMap = Maps.newHashMap();
        auditMap.put("containerID", containerID.toString());
        auditMap.put("remoteUser", remoteUser.getUserName());
        try {
            ReconciliationEligibilityHandler.EligibilityResult result = ReconciliationEligibilityHandler.isEligibleForReconciliation(containerID, this.getScm().getContainerManager());
            if (!result.isOk()) {
                switch (result.getResult()) {
                    case OK: {
                        break;
                    }
                    case CONTAINER_NOT_FOUND: {
                        throw new ContainerNotFoundException(result.toString());
                    }
                    case INELIGIBLE_CONTAINER_STATE: {
                        throw new SCMException(result.toString(), SCMException.ResultCodes.UNEXPECTED_CONTAINER_STATE);
                    }
                    case INELIGIBLE_REPLICA_STATES: 
                    case INELIGIBLE_REPLICATION_TYPE: 
                    case NOT_ENOUGH_REQUIRED_NODES: 
                    case NO_REPLICAS_FOUND: {
                        throw new SCMException(result.toString(), SCMException.ResultCodes.UNSUPPORTED_OPERATION);
                    }
                    default: {
                        throw new SCMException("Unknown reconciliation eligibility result " + result, SCMException.ResultCodes.INTERNAL_ERROR);
                    }
                }
            }
            this.scm.getEventQueue().fireEvent(SCMEvents.RECONCILE_CONTAINER, (Object)containerID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess(SCMAction.RECONCILE_CONTAINER, auditMap));
        }
        catch (SCMException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure(SCMAction.RECONCILE_CONTAINER, auditMap, ex));
            throw ex;
        }
    }
}

