/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.lib.wsrs;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExceptionProvider
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionProvider.class);
    private static final String ENTER = System.getProperty("line.separator");

    protected Response createResponse(Response.Status status, Throwable throwable) {
        return HttpExceptionUtils.createJerseyExceptionResponse((Response.Status)status, (Throwable)throwable);
    }

    protected String getOneLineMessage(Throwable throwable) {
        int i;
        String message = throwable.getMessage();
        if (message != null && (i = message.indexOf(ENTER)) > -1) {
            message = message.substring(0, i);
        }
        return message;
    }

    protected void log(Response.Status status, Throwable throwable) {
        LOG.debug("{}", (Object)throwable.getMessage(), (Object)throwable);
    }

    public Response toResponse(Throwable throwable) {
        return this.createResponse(Response.Status.BAD_REQUEST, throwable);
    }
}

