/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.s3.util;

import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.ozone.s3.exception.OS3Exception;
import org.apache.hadoop.ozone.s3.exception.S3ErrorTable;
import org.apache.hadoop.ozone.s3.util.S3StorageType;

public final class S3Utils {
    public static String urlDecode(String str) throws UnsupportedEncodingException {
        return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
    }

    public static String urlEncode(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
    }

    private S3Utils() {
    }

    public static ReplicationConfig resolveS3ClientSideReplicationConfig(String s3StorageTypeHeader, String s3StorageConfigHeader, ReplicationConfig clientConfiguredReplConfig, ReplicationConfig bucketReplConfig) throws OS3Exception {
        if (!StringUtils.isEmpty((CharSequence)s3StorageTypeHeader)) {
            return S3Utils.toReplicationConfig(s3StorageTypeHeader, s3StorageConfigHeader);
        }
        return clientConfiguredReplConfig != null ? clientConfiguredReplConfig : bucketReplConfig;
    }

    public static ReplicationConfig toReplicationConfig(String s3StorageType, String s3StorageConfig) throws OS3Exception {
        try {
            S3StorageType storageType = S3StorageType.valueOf(s3StorageType);
            if (S3StorageType.STANDARD_IA.equals((Object)storageType) && !StringUtils.isEmpty((CharSequence)s3StorageConfig)) {
                return new ECReplicationConfig(s3StorageConfig);
            }
            return storageType.getReplicationConfig();
        }
        catch (IllegalArgumentException ex) {
            throw S3ErrorTable.newError(S3ErrorTable.INVALID_STORAGE_CLASS, s3StorageType, ex);
        }
    }

    public static WebApplicationException wrapOS3Exception(OS3Exception ex) {
        return new WebApplicationException(ex.getErrorMessage(), (Throwable)ex, Response.status((int)ex.getHttpCode()).entity((Object)ex.toXml()).build());
    }

    public static boolean hasUnsignedPayload(@Nonnull String amzContentSha256Header) {
        Objects.requireNonNull(amzContentSha256Header);
        return amzContentSha256Header.equals("UNSIGNED-PAYLOAD") || amzContentSha256Header.equals("STREAMING-UNSIGNED-PAYLOAD-TRAILER");
    }

    public static boolean hasMultiChunksPayload(@Nonnull String amzContentSha256Header) {
        Objects.requireNonNull(amzContentSha256Header);
        return amzContentSha256Header.startsWith("STREAMING");
    }

    public static void validateMultiChunksUpload(HttpHeaders headers, String amzDecodedContentLength, String resource) throws OS3Exception {
        boolean containsAwsChunked;
        String contentEncoding = headers.getHeaderString("Content-Encoding");
        if (contentEncoding != null && !(containsAwsChunked = Arrays.stream(contentEncoding.split(",")).map(String::trim).anyMatch("aws-chunked"::equals))) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, resource);
            ex.setErrorMessage("An error occurred (InvalidArgument) for multi chunks upload: The Content-Encoding header does not contain aws-chunked");
            throw ex;
        }
        if (amzDecodedContentLength == null) {
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, resource);
            ex.setErrorMessage("An error occurred (InvalidArgument) for multi chunks upload: The x-amz-decoded-content-length header is not specified");
            throw ex;
        }
    }

    public static String validateSignatureHeader(HttpHeaders headers, String resource, boolean isSignedPayload) throws OS3Exception {
        String xAmzContentSha256Header = headers.getHeaderString("x-amz-content-sha256");
        if (xAmzContentSha256Header == null) {
            if (!isSignedPayload) {
                return "UNSIGNED-PAYLOAD";
            }
            OS3Exception ex = S3ErrorTable.newError(S3ErrorTable.INVALID_ARGUMENT, resource);
            ex.setErrorMessage("An error occurred (InvalidArgument): The x-amz-content-sha256 header is not specified");
            throw ex;
        }
        return xAmzContentSha256Header;
    }

    public static boolean eol(int prev, int curr) {
        return prev == 13 && curr == 10;
    }

    public static String generateCanonicalUserId(String input) {
        return DigestUtils.sha256Hex((String)input);
    }
}

