/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.compaction.log;

import java.util.Objects;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.rocksdb.LiveFileMetaData;

public class SstFileInfo
implements CopyObject<SstFileInfo> {
    private final String fileName;
    private final String startKey;
    private final String endKey;
    private final String columnFamily;

    public SstFileInfo(String fileName, String startRange, String endRange, String columnFamily) {
        this.fileName = fileName;
        this.startKey = startRange;
        this.endKey = endRange;
        this.columnFamily = columnFamily;
    }

    public SstFileInfo(LiveFileMetaData fileMetaData) {
        this(fileMetaData.fileName(), StringUtils.bytes2String((byte[])fileMetaData.smallestKey()), StringUtils.bytes2String((byte[])fileMetaData.largestKey()), StringUtils.bytes2String((byte[])fileMetaData.columnFamilyName()));
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStartKey() {
        return this.startKey;
    }

    public String getEndKey() {
        return this.endKey;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String toString() {
        return String.format("fileName: '%s', startKey: '%s', endKey: '%s', columnFamily: '%s'", this.fileName, this.startKey, this.endKey, this.columnFamily);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SstFileInfo)) {
            return false;
        }
        SstFileInfo that = (SstFileInfo)o;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.startKey, that.startKey) && Objects.equals(this.endKey, that.endKey) && Objects.equals(this.columnFamily, that.columnFamily);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.startKey, this.endKey, this.columnFamily);
    }

    public SstFileInfo copyObject() {
        return new SstFileInfo(this.fileName, this.startKey, this.endKey, this.columnFamily);
    }
}

