/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.utils;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.ratis.util.TimeDuration;

@InterfaceAudience.Private
public final class OzoneUtils {
    public static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };

    private OzoneUtils() {
    }

    public static void verifyMaxKeyLength(String length) throws IllegalArgumentException {
        int maxKey = 0;
        try {
            maxKey = Integer.parseInt(length);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid max key length, the value should be digital.");
        }
        if (maxKey <= 0) {
            throw new IllegalArgumentException("Invalid max key length, the value should be a positive number.");
        }
    }

    public static String getRequestID() {
        return UUID.randomUUID().toString();
    }

    public static String getHostName() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return host;
    }

    public static String formatTime(long millis) {
        return DATE_FORMAT.get().format(millis);
    }

    public static long formatDate(String date) throws ParseException {
        Preconditions.checkNotNull((Object)date, (Object)"Date string should not be null.");
        return DATE_FORMAT.get().parse(date).getTime();
    }

    public static void verifyResourceName(String resName) throws IllegalArgumentException {
        HddsClientUtils.verifyResourceName((String)resName);
    }

    public static TimeDuration getTimeDuration(ConfigurationSource conf, String key, TimeDuration defaultValue) {
        TimeUnit defaultTimeUnit = defaultValue.getUnit();
        long timeDurationInDefaultUnit = conf.getTimeDuration(key, defaultValue.getDuration(), defaultTimeUnit);
        return TimeDuration.valueOf((long)timeDurationInDefaultUnit, (TimeUnit)defaultTimeUnit);
    }

    public static long getTimeDurationInMS(ConfigurationSource conf, String key, TimeDuration defaultValue) {
        return OzoneUtils.getTimeDuration(conf, key, defaultValue).toLong(TimeUnit.MILLISECONDS);
    }
}

