/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeAdminProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
@InterfaceStability.Unstable
public final class CombinedHostsFileReader {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedHostsFileReader.class);
    private static final String REFER_TO_DOC_MSG = " For the correct JSON format please refer to the documentation (https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-hdfs/HdfsDataNodeAdminGuide.html#JSON-based_configuration)";

    private CombinedHostsFileReader() {
    }

    public static DatanodeAdminProperties[] readFile(String hostsFilePath) throws IOException {
        DatanodeAdminProperties[] allDNs = new DatanodeAdminProperties[]{};
        ObjectMapper objectMapper = new ObjectMapper();
        File hostFile = new File(hostsFilePath);
        boolean tryOldFormat = false;
        if (hostFile.length() > 0L) {
            try (InputStreamReader input = new InputStreamReader(Files.newInputStream(hostFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                allDNs = (DatanodeAdminProperties[])objectMapper.readValue((Reader)input, DatanodeAdminProperties[].class);
            }
            catch (JsonMappingException jme) {
                tryOldFormat = true;
            }
        } else {
            LOG.warn(hostsFilePath + " is empty." + REFER_TO_DOC_MSG);
        }
        if (tryOldFormat) {
            ObjectReader objectReader = objectMapper.readerFor(DatanodeAdminProperties.class);
            JsonFactory jsonFactory = new JsonFactory();
            ArrayList<DatanodeAdminProperties> all = new ArrayList<DatanodeAdminProperties>();
            try (InputStreamReader input = new InputStreamReader(Files.newInputStream(Paths.get(hostsFilePath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                MappingIterator iterator = objectReader.readValues(jsonFactory.createParser((Reader)input));
                while (iterator.hasNext()) {
                    DatanodeAdminProperties properties = (DatanodeAdminProperties)iterator.next();
                    all.add(properties);
                }
                LOG.warn(hostsFilePath + " has legacy JSON format." + REFER_TO_DOC_MSG);
            }
            catch (Throwable ex) {
                LOG.warn(hostsFilePath + " has invalid JSON format." + REFER_TO_DOC_MSG, ex);
            }
            allDNs = all.toArray(new DatanodeAdminProperties[all.size()]);
        }
        return allDNs;
    }
}

