/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.shard;

import com.google.common.base.Strings;
import io.oxia.client.shard.NoShardAvailableException;
import io.oxia.client.shard.Shard;
import io.oxia.client.shard.ShardManager;
import io.oxia.client.shard.ShardStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import lombok.Generated;

public class ShardAssignmentsContainer {
    private final ConcurrentMap<Long, Shard> shards = new ConcurrentHashMap<Long, Shard>();
    private final ShardStrategy shardStrategy;
    private final String namespace;

    ShardAssignmentsContainer(ShardStrategy shardStrategy, String namespace) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
        this.shardStrategy = shardStrategy;
        this.namespace = namespace;
    }

    public long getShardForKey(String key) {
        Predicate<Shard> test = this.shardStrategy.acceptsKeyPredicate(key);
        Optional<Shard> shard = this.shards.values().stream().filter(test).findFirst();
        if (shard.isPresent()) {
            return shard.get().id();
        }
        throw new NoShardAvailableException(key);
    }

    public String leader(long shardId) {
        Shard shard = (Shard)this.shards.get(shardId);
        if (shard == null) {
            throw new NoShardAvailableException(shardId);
        }
        return shard.leader();
    }

    void update(ShardManager.ShardAssignmentChanges changes) {
        changes.added().forEach(s -> this.shards.put(s.id(), (Shard)s));
        changes.reassigned().forEach(s -> this.shards.put(s.id(), (Shard)s));
        changes.removed().forEach(s -> this.shards.remove(s.id(), s));
    }

    Set<Long> allShardIds() {
        return this.shards.keySet();
    }

    Map<Long, Shard> allShards() {
        return this.shards;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }
}

