/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.policies.data.loadbalancer;

import java.io.Serializable;
import lombok.Generated;

public class NamespaceBundleStats
implements Comparable<NamespaceBundleStats>,
Serializable {
    public double msgRateIn;
    public double msgThroughputIn;
    public double msgRateOut;
    public double msgThroughputOut;
    public int consumerCount;
    public int producerCount;
    public long topics;
    public long cacheSize;
    private static final double throughputComparisonResolution = 100000.0;
    private static final double msgRateComparisonResolution = 100.0;
    private static final long topicConnectionComparisonResolution = 500L;
    private static final long cacheSizeComparisonResolution = 100000L;

    public NamespaceBundleStats() {
        this.reset();
    }

    public void reset() {
        this.msgRateIn = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputOut = 0.0;
        this.consumerCount = 0;
        this.producerCount = 0;
        this.topics = 0L;
        this.cacheSize = 0L;
    }

    @Override
    public int compareTo(NamespaceBundleStats other) {
        int result = this.compareByBandwidthIn(other);
        if (result == 0) {
            result = this.compareByBandwidthOut(other);
        }
        if (result == 0) {
            result = this.compareByMsgRate(other);
        }
        if (result == 0) {
            result = this.compareByTopicConnections(other);
        }
        if (result == 0) {
            result = this.compareByCacheSize(other);
        }
        return result;
    }

    public int compareByMsgRate(NamespaceBundleStats other) {
        double thisMsgRate = this.msgRateIn + this.msgRateOut;
        double otherMsgRate = other.msgRateIn + other.msgRateOut;
        return NamespaceBundleStats.compareDoubleWithResolution(thisMsgRate, otherMsgRate, 100.0);
    }

    private static int compareDoubleWithResolution(double v1, double v2, double resolution) {
        return Long.compare(Math.round(v1 / resolution), Math.round(v2 / resolution));
    }

    private static int compareLongWithResolution(long v1, long v2, long resolution) {
        return Long.compare(v1 / resolution, v2 / resolution);
    }

    public int compareByTopicConnections(NamespaceBundleStats other) {
        long thisTopicsAndConnections = this.topics + (long)this.consumerCount + (long)this.producerCount;
        long otherTopicsAndConnections = other.topics + (long)other.consumerCount + (long)other.producerCount;
        return NamespaceBundleStats.compareLongWithResolution(thisTopicsAndConnections, otherTopicsAndConnections, 500L);
    }

    public int compareByCacheSize(NamespaceBundleStats other) {
        return NamespaceBundleStats.compareLongWithResolution(this.cacheSize, other.cacheSize, 100000L);
    }

    public int compareByBandwidthIn(NamespaceBundleStats other) {
        return NamespaceBundleStats.compareDoubleWithResolution(this.msgThroughputIn, other.msgThroughputIn, 100000.0);
    }

    public int compareByBandwidthOut(NamespaceBundleStats other) {
        return NamespaceBundleStats.compareDoubleWithResolution(this.msgThroughputOut, other.msgThroughputOut, 100000.0);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamespaceBundleStats)) {
            return false;
        }
        NamespaceBundleStats other = (NamespaceBundleStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.msgRateIn, other.msgRateIn) != 0) {
            return false;
        }
        if (Double.compare(this.msgThroughputIn, other.msgThroughputIn) != 0) {
            return false;
        }
        if (Double.compare(this.msgRateOut, other.msgRateOut) != 0) {
            return false;
        }
        if (Double.compare(this.msgThroughputOut, other.msgThroughputOut) != 0) {
            return false;
        }
        if (this.consumerCount != other.consumerCount) {
            return false;
        }
        if (this.producerCount != other.producerCount) {
            return false;
        }
        if (this.topics != other.topics) {
            return false;
        }
        return this.cacheSize == other.cacheSize;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NamespaceBundleStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateIn = Double.doubleToLongBits(this.msgRateIn);
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.msgThroughputIn);
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgRateOut = Double.doubleToLongBits(this.msgRateOut);
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.msgThroughputOut);
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        result = result * 59 + this.consumerCount;
        result = result * 59 + this.producerCount;
        long $topics = this.topics;
        result = result * 59 + (int)($topics >>> 32 ^ $topics);
        long $cacheSize = this.cacheSize;
        result = result * 59 + (int)($cacheSize >>> 32 ^ $cacheSize);
        return result;
    }

    @Generated
    public String toString() {
        return "NamespaceBundleStats(msgRateIn=" + this.msgRateIn + ", msgThroughputIn=" + this.msgThroughputIn + ", msgRateOut=" + this.msgRateOut + ", msgThroughputOut=" + this.msgThroughputOut + ", consumerCount=" + this.consumerCount + ", producerCount=" + this.producerCount + ", topics=" + this.topics + ", cacheSize=" + this.cacheSize + ")";
    }
}

