/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import lombok.Generated;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationParameters;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.service.api.Workers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/worker-stats")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/worker-stats", description="Workers stats api", tags={"workers-stats"})
public class WorkerStatsApiV2Resource
implements Supplier<WorkerService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkerStatsApiV2Resource.class);
    public static final String ATTRIBUTE_WORKERSTATS_SERVICE = "worker-stats";
    private WorkerService workerService;
    @Context
    protected ServletContext servletContext;
    @Context
    protected HttpServletRequest httpRequest;

    @Override
    public synchronized WorkerService get() {
        if (this.workerService == null) {
            this.workerService = (WorkerService)this.servletContext.getAttribute(ATTRIBUTE_WORKERSTATS_SERVICE);
        }
        return this.workerService;
    }

    Workers<? extends WorkerService> workers() {
        return this.get().getWorkers();
    }

    AuthenticationParameters authParams() {
        return AuthenticationParameters.builder().clientRole(this.clientAppId()).originalPrincipal(this.httpRequest.getHeader("X-Original-Principal")).clientAuthenticationDataSource((AuthenticationDataSource)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedDataAttributeName)).build();
    }

    @Deprecated
    public String clientAppId() {
        return this.httpRequest != null ? (String)this.httpRequest.getAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName) : null;
    }

    @GET
    @Path(value="/metrics")
    @ApiOperation(value="Gets the metrics for Monitoring", notes="Request should be executed by Monitoring agent on each worker to fetch the worker-metrics", response=Metrics.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    @Produces(value={"application/json"})
    public List<Metrics> getMetrics() throws Exception {
        return this.workers().getWorkerMetrics(this.authParams());
    }

    @GET
    @Path(value="/functionsmetrics")
    @ApiOperation(value="Get metrics for all functions owned by worker", notes="Requested should be executed by Monitoring agent on each worker to fetch the metrics", response=WorkerFunctionInstanceStats.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Don't have admin permission"), @ApiResponse(code=503, message="Worker service is not running")})
    @Produces(value={"application/json"})
    public List<WorkerFunctionInstanceStats> getStats() throws IOException {
        return this.workers().getFunctionsMetrics(this.authParams());
    }
}

