/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.Comparator;
import java.util.Map;
import org.apache.pulsar.broker.loadbalance.LoadRanker;
import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAvailabilityRanker
implements LoadRanker,
Comparator<ResourceDescription> {
    private static final Logger log = LoggerFactory.getLogger(ResourceAvailabilityRanker.class);

    @Override
    public long getRank(ResourceDescription resourceDescription) {
        int weight = 1;
        int availabilityRank = 0;
        int resourcesWithLowAvailability = 0;
        int minAvailableRequired = 20;
        int absolutelyMinRequiredToFunction = 5;
        boolean makeNonFunctional = false;
        for (Map.Entry<String, ResourceUsage> entry : resourceDescription.getResourceUsage().entrySet()) {
            int percentAvailable = 0;
            if (entry.getValue().limit > 0.0 && entry.getValue().limit > entry.getValue().usage) {
                Double temp = (entry.getValue().limit - entry.getValue().usage) / entry.getValue().limit * 100.0;
                percentAvailable = temp.intValue();
            }
            log.debug("Resource [{}] in Percentage Available - [{}], Actual Usage is - [{}], Actual Limit is [{}]", new Object[]{entry.getKey(), percentAvailable, entry.getValue().usage, entry.getValue().limit});
            int resourceWeight = weight * percentAvailable;
            if (percentAvailable < minAvailableRequired) {
                ++resourcesWithLowAvailability;
            }
            availabilityRank += resourceWeight;
            if (percentAvailable >= absolutelyMinRequiredToFunction) continue;
            makeNonFunctional = true;
        }
        if (resourcesWithLowAvailability > 0) {
            availabilityRank /= resourcesWithLowAvailability * 2;
            log.debug("Total Resource with Low availability - [{}]", (Object)resourcesWithLowAvailability);
        }
        if (makeNonFunctional) {
            availabilityRank = 0;
            log.debug("ResourceUnit set to non-functional due to extremely low resources");
        }
        return availabilityRank;
    }

    @Override
    public int compare(ResourceDescription rd1, ResourceDescription rd2) {
        return Long.valueOf(this.getRank(rd1)).compareTo(this.getRank(rd2));
    }
}

