/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema.validator;

import org.apache.pulsar.broker.service.schema.exceptions.InvalidSchemaDataException;
import org.apache.pulsar.broker.service.schema.validator.SchemaDataValidator;
import org.apache.pulsar.common.protocol.schema.SchemaData;

class PrimitiveSchemaDataValidator
implements SchemaDataValidator {
    private static final PrimitiveSchemaDataValidator INSTANCE = new PrimitiveSchemaDataValidator();

    public static PrimitiveSchemaDataValidator of() {
        return INSTANCE;
    }

    private PrimitiveSchemaDataValidator() {
    }

    @Override
    public void validate(SchemaData schemaData) throws InvalidSchemaDataException {
        byte[] data = schemaData.getData();
        if (null != data && data.length > 0) {
            throw new InvalidSchemaDataException("Invalid schema definition data for primitive schemas :length of schema data should be zero, but " + data.length + " bytes is found");
        }
    }
}

