/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.util.Objects;
import org.apache.qpid.server.security.access.OperationType;

public final class Operation {
    public static final Operation CREATE = new Operation(OperationType.CREATE);
    public static final Operation UPDATE = new Operation(OperationType.UPDATE);
    public static final Operation DELETE = new Operation(OperationType.DELETE);
    public static final Operation DISCOVER = new Operation(OperationType.DISCOVER);
    public static final Operation READ = new Operation(OperationType.READ);
    private final OperationType _type;
    private final String _name;

    private Operation(OperationType type) {
        this(type, type.name());
    }

    private Operation(OperationType type, String name) {
        this._type = type;
        this._name = name;
    }

    public OperationType getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public static Operation CREATE() {
        return CREATE;
    }

    public static Operation UPDATE() {
        return UPDATE;
    }

    public static Operation DELETE() {
        return DELETE;
    }

    public static Operation DISCOVER() {
        return DISCOVER;
    }

    public static Operation READ() {
        return READ;
    }

    public static Operation INVOKE_METHOD(String name) {
        return new Operation(OperationType.INVOKE_METHOD, name);
    }

    public static Operation PERFORM_ACTION(String name) {
        return new Operation(OperationType.PERFORM_ACTION, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Operation operation = (Operation)o;
        return this.getType() == operation.getType() && Objects.equals(this.getName(), operation.getName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getName()});
    }

    public String toString() {
        return "Operation[" + String.valueOf((Object)this._type) + (String)(this._name.equals(this._type.name()) ? "" : "(" + this._name + ")") + "]";
    }
}

