/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.Date;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.LongGetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class Int64WriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Long.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new Int64PrimitiveSchema(protoField, propertyDescriptor);
        }
        return new Int64Schema(protoField, propertyDescriptor);
    }

    private static final class Int64PrimitiveSchema<T>
    extends Int64DynamicSchema<T> {
        private final LongGetter<T> primitiveGetter;

        public Int64PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (LongGetter)propertyDescriptor.getGetter();
        }

        @Override
        public void getAndWriteTo(OutputEx output, T message) throws IOException {
            long value = this.primitiveGetter.get(message);
            output.writeScalarInt64(this.tag, this.tagSize, value);
        }
    }

    private static class Int64Schema<T>
    extends Int64DynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public Int64Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class Int64DynamicSchema<T>
    extends FieldSchema<T> {
        public Int64DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarInt64(this.tag, this.tagSize, ((Number)value).longValue());
                return;
            }
            if (value instanceof Date) {
                long parsedValue = ((Date)value).getTime();
                output.writeScalarInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof LocalDate) {
                long parsedValue = ((LocalDate)value).getLong(ChronoField.EPOCH_DAY);
                output.writeScalarInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof LocalDateTime) {
                long parsedValue = ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli();
                output.writeScalarInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                long parsedValue;
                if (((String)value).contains(":")) {
                    OffsetDateTime offsetDateTime = OffsetDateTime.parse((String)value);
                    parsedValue = offsetDateTime.toInstant().toEpochMilli();
                } else {
                    parsedValue = Long.parseLong((String)value, 10);
                }
                output.writeScalarInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                long parsedValue = Long.parseLong(((String[])value)[0], 10);
                output.writeScalarInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

