/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.spring.core.setup;

import lombok.Generated;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.kernel.internal.setup.JobClassNameProvider;
import org.apache.shardingsphere.elasticjob.spring.core.util.AopTargetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public final class SpringProxyJobClassNameProvider
implements JobClassNameProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringProxyJobClassNameProvider.class);
    private static final String LAMBDA_CHARACTERISTICS = "$$Lambda";

    public SpringProxyJobClassNameProvider() {
        log.info("create SpringProxyJobClassNameProvider");
    }

    public String getJobClassName(ElasticJob elasticJob) {
        if (!AopUtils.isAopProxy((Object)elasticJob)) {
            return this.getJobClassName(elasticJob.getClass());
        }
        return this.getJobClassName(AopTargetUtils.getTarget(elasticJob).getClass());
    }

    private String getJobClassName(Class<?> elasticJobClass) {
        String elasticJobClassName = elasticJobClass.getName();
        return this.isLambdaClass(elasticJobClass) ? this.trimLambdaClassSuffix(elasticJobClassName) : elasticJobClassName;
    }

    private boolean isLambdaClass(Class<?> elasticJobClass) {
        return elasticJobClass.isSynthetic() && elasticJobClass.getSimpleName().contains(LAMBDA_CHARACTERISTICS);
    }

    private String trimLambdaClassSuffix(String className) {
        return className.substring(0, className.lastIndexOf(LAMBDA_CHARACTERISTICS) + LAMBDA_CHARACTERISTICS.length());
    }
}

