/*
 * Decompiled with CFR 0.152.
 */
package io.fury.serializer;

import io.fury.Fury;
import io.fury.codegen.Expression;
import io.fury.config.LongEncoding;
import io.fury.memory.MemoryBuffer;
import io.fury.serializer.Serializer;
import io.fury.serializer.Serializers;
import io.fury.type.Type;
import io.fury.type.TypeUtils;
import io.fury.util.Preconditions;

public class PrimitiveSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Boolean.TYPE, new BooleanSerializer(fury, (Class<?>)Boolean.TYPE));
        fury.registerSerializer(Byte.TYPE, new ByteSerializer(fury, (Class<?>)Byte.TYPE));
        fury.registerSerializer(Short.TYPE, new ShortSerializer(fury, (Class<?>)Short.TYPE));
        fury.registerSerializer(Character.TYPE, new CharSerializer(fury, (Class<?>)Character.TYPE));
        fury.registerSerializer(Integer.TYPE, new IntSerializer(fury, (Class<?>)Integer.TYPE));
        fury.registerSerializer(Long.TYPE, new LongSerializer(fury, (Class<?>)Long.TYPE));
        fury.registerSerializer(Float.TYPE, new FloatSerializer(fury, (Class<?>)Float.TYPE));
        fury.registerSerializer(Double.TYPE, new DoubleSerializer(fury, (Class<?>)Double.TYPE));
        fury.registerSerializer(Boolean.class, new BooleanSerializer(fury, Boolean.class));
        fury.registerSerializer(Byte.class, new ByteSerializer(fury, Byte.class));
        fury.registerSerializer(Short.class, new ShortSerializer(fury, Short.class));
        fury.registerSerializer(Character.class, new CharSerializer(fury, Character.class));
        fury.registerSerializer(Integer.class, new IntSerializer(fury, Integer.class));
        fury.registerSerializer(Long.class, new LongSerializer(fury, Long.class));
        fury.registerSerializer(Float.class, new FloatSerializer(fury, Float.class));
        fury.registerSerializer(Double.class, new DoubleSerializer(fury, Double.class));
    }

    public static final class BooleanSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Boolean> {
        public BooleanSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.BOOL.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Boolean value) {
            buffer.writeBoolean(value);
        }

        @Override
        public Boolean read(MemoryBuffer buffer) {
            return buffer.readBoolean();
        }
    }

    public static final class ByteSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Byte> {
        public ByteSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT8.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Byte value) {
            buffer.writeByte(value);
        }

        @Override
        public Byte read(MemoryBuffer buffer) {
            return buffer.readByte();
        }
    }

    public static final class ShortSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Short> {
        public ShortSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT16.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Short value) {
            buffer.writeShort(value);
        }

        @Override
        public Short read(MemoryBuffer buffer) {
            return buffer.readShort();
        }
    }

    public static final class CharSerializer
    extends Serializer<Character> {
        public CharSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Character value) {
            buffer.writeChar(value.charValue());
        }

        @Override
        public Character read(MemoryBuffer buffer) {
            return Character.valueOf(buffer.readChar());
        }
    }

    public static final class IntSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Integer> {
        private final boolean compressNumber;

        public IntSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT32.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
            this.compressNumber = fury.compressInt();
        }

        @Override
        public void write(MemoryBuffer buffer, Integer value) {
            if (this.compressNumber) {
                buffer.writeVarInt(value);
            } else {
                buffer.writeInt(value);
            }
        }

        @Override
        public Integer read(MemoryBuffer buffer) {
            if (this.compressNumber) {
                return buffer.readVarInt();
            }
            return buffer.readInt();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            buffer.writeInt(value);
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            return buffer.readInt();
        }
    }

    public static final class LongSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Long> {
        private final LongEncoding longEncoding;

        public LongSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.INT64.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
            this.longEncoding = fury.longEncoding();
        }

        @Override
        public void write(MemoryBuffer buffer, Long value) {
            LongSerializer.writeLong(buffer, value, this.longEncoding);
        }

        @Override
        public Long read(MemoryBuffer buffer) {
            return LongSerializer.readLong(buffer, this.longEncoding);
        }

        public static String writeLongFunc(LongEncoding longEncoding, boolean ensureBounds) {
            switch (longEncoding) {
                case LE_RAW_BYTES: {
                    return ensureBounds ? "writeLong" : "unsafeWriteVarLong";
                }
                case SLI: {
                    return ensureBounds ? "writeSliLong" : "unsafeWriteSliLong";
                }
                case PVL: {
                    return ensureBounds ? "writeVarLong" : "unsafeWriteVarLong";
                }
            }
            throw new UnsupportedOperationException("Unsupported long encoding " + (Object)((Object)longEncoding));
        }

        public static Expression writeLong(Expression buffer, Expression v, LongEncoding longEncoding, boolean ensureBounds) {
            return new Expression.Invoke(buffer, LongSerializer.writeLongFunc(longEncoding, ensureBounds), v);
        }

        public static void writeLong(MemoryBuffer buffer, long value, LongEncoding longEncoding) {
            if (longEncoding == LongEncoding.SLI) {
                buffer.writeSliLong(value);
            } else if (longEncoding == LongEncoding.LE_RAW_BYTES) {
                buffer.writeLong(value);
            } else {
                buffer.writeVarLong(value);
            }
        }

        public static long readLong(MemoryBuffer buffer, LongEncoding longEncoding) {
            if (longEncoding == LongEncoding.SLI) {
                return buffer.readSliLong();
            }
            if (longEncoding == LongEncoding.LE_RAW_BYTES) {
                return buffer.readLong();
            }
            return buffer.readVarLong();
        }

        public static Expression readLong(Expression buffer, LongEncoding longEncoding) {
            return new Expression.Invoke(buffer, LongSerializer.readLongFunc(longEncoding), TypeUtils.PRIMITIVE_LONG_TYPE);
        }

        public static String readLongFunc(LongEncoding longEncoding) {
            switch (longEncoding) {
                case LE_RAW_BYTES: {
                    return "readLong";
                }
                case SLI: {
                    return "readSliLong";
                }
                case PVL: {
                    return "readVarLong";
                }
            }
            throw new UnsupportedOperationException("Unsupported long encoding " + (Object)((Object)longEncoding));
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Long value) {
            buffer.writeLong(value);
        }

        @Override
        public Long xread(MemoryBuffer buffer) {
            return buffer.readLong();
        }
    }

    public static final class FloatSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Float> {
        public FloatSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.FLOAT.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Float value) {
            buffer.writeFloat(value.floatValue());
        }

        @Override
        public Float read(MemoryBuffer buffer) {
            return Float.valueOf(buffer.readFloat());
        }
    }

    public static final class DoubleSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<Double> {
        public DoubleSerializer(Fury fury, Class<?> cls) {
            super(fury, cls, Type.DOUBLE.getId(), !cls.isPrimitive() && !fury.isBasicTypesRefIgnored());
        }

        @Override
        public void write(MemoryBuffer buffer, Double value) {
            buffer.writeDouble(value);
        }

        @Override
        public Double read(MemoryBuffer buffer) {
            return buffer.readDouble();
        }
    }

    public static final class Uint16Serializer
    extends Serializer<Integer> {
        public Uint16Serializer(Fury fury) {
            super(fury, Integer.class);
        }

        @Override
        public short getXtypeId() {
            return Type.UINT16.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument(value >= 0 && value <= 65535);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 16;
        }
    }

    public static final class Uint8Serializer
    extends Serializer<Integer> {
        public Uint8Serializer(Fury fury) {
            super(fury, Integer.class);
        }

        @Override
        public short getXtypeId() {
            return Type.UINT8.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Integer value) {
            Preconditions.checkArgument(value >= 0 && value <= 255);
            buffer.writeByte(value.byteValue());
        }

        @Override
        public Integer xread(MemoryBuffer buffer) {
            byte b = buffer.readByte();
            return b >>> 24;
        }
    }
}

