/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals;

import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.ReflectiveStrategy;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.SecurityManagerCompatibility;

class LegacyStrategy
implements SecurityManagerCompatibility {
    private final Method doPrivileged;
    private final Method getContext;
    private final Method getSubject;
    private final Method doAs;

    LegacyStrategy(ReflectiveStrategy.Loader loader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> accessController = loader.loadClass("java.security.AccessController");
        this.doPrivileged = accessController.getDeclaredMethod("doPrivileged", PrivilegedAction.class);
        this.getContext = accessController.getDeclaredMethod("getContext", new Class[0]);
        Class<?> accessControlContext = loader.loadClass("java.security.AccessControlContext");
        Class<?> subject = loader.loadClass(Subject.class.getName());
        this.getSubject = subject.getDeclaredMethod("getSubject", accessControlContext);
        this.doAs = subject.getDeclaredMethod("doAs", Subject.class, PrivilegedExceptionAction.class);
    }

    @Override
    public <T> T doPrivileged(PrivilegedAction<T> action) {
        return (T)ReflectiveStrategy.invoke(this.doPrivileged, null, action);
    }

    private Object getContext() {
        return ReflectiveStrategy.invoke(this.getContext, null, new Object[0]);
    }

    private Subject getSubject(Object context) {
        return (Subject)ReflectiveStrategy.invoke(this.getSubject, null, context);
    }

    @Override
    public Subject current() {
        return this.getSubject(this.getContext());
    }

    private <T> T doAs(Subject subject, PrivilegedExceptionAction<T> action) throws PrivilegedActionException {
        return (T)ReflectiveStrategy.invokeChecked(this.doAs, PrivilegedActionException.class, null, subject, action);
    }

    @Override
    public <T> T callAs(Subject subject, Callable<T> callable) throws CompletionException {
        try {
            return (T)this.doAs(subject, callable::call);
        }
        catch (PrivilegedActionException e) {
            throw new CompletionException(e.getCause());
        }
    }
}

